/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.voting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Classifier;
import sklearn.HasEstimatorEnsemble;
import sklearn.SkLearnClassifier;
import sklearn.StepUtil;

public class VotingClassifier
extends SkLearnClassifier
implements HasEstimatorEnsemble<Classifier> {
    private static final String VOTING_HARD = "hard";
    private static final String VOTING_SOFT = "soft";

    public VotingClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<Classifier> estimators = this.getEstimators();
        return StepUtil.getNumberOfFeatures(estimators);
    }

    public MiningModel encodeModel(Schema schema) {
        List<Classifier> estimators = this.getEstimators();
        String voting = this.getVoting();
        List<Number> weights = this.getWeights();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        ArrayList<Model> models = new ArrayList<Model>();
        for (Classifier estimator : estimators) {
            Model model = estimator.encode(schema);
            models.add(model);
        }
        Segmentation.MultipleModelMethod multipleModelMethod = VotingClassifier.parseVoting(voting, weights != null && !weights.isEmpty());
        MiningModel miningModel = new MiningModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, models, weights));
        this.encodePredictProbaOutput((Model)miningModel, DataType.DOUBLE, (DiscreteLabel)categoricalLabel);
        return miningModel;
    }

    @Override
    public List<Classifier> getEstimators() {
        return this.getList("estimators_", Classifier.class);
    }

    public String getVoting() {
        return (String)this.getEnum("voting", arg_0 -> ((VotingClassifier)this).getString(arg_0), Arrays.asList(VOTING_HARD, VOTING_SOFT));
    }

    public List<Number> getWeights() {
        Object weights = this.getOptionalObject("weights");
        if (weights == null || weights instanceof List) {
            return (List)weights;
        }
        return this.getNumberArray("weights");
    }

    private static Segmentation.MultipleModelMethod parseVoting(String voting, boolean weighted) {
        switch (voting) {
            case "hard": {
                return weighted ? Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE : Segmentation.MultipleModelMethod.MAJORITY_VOTE;
            }
            case "soft": {
                return weighted ? Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE : Segmentation.MultipleModelMethod.AVERAGE;
            }
        }
        throw new IllegalArgumentException(voting);
    }
}

