/*
 * Decompiled with CFR 0.152.
 */
package sklearn.loss;

import java.util.AbstractList;
import java.util.List;
import sklearn.HasPriorProbability;
import sklearn.loss.Link;

public class LogitLink
extends Link {
    public LogitLink(String module, String name) {
        super(module, name);
    }

    public List<Double> computeInitialPredictions(final int numClasses, final HasPriorProbability hasPriorProbability) {
        AbstractList<Double> result = new AbstractList<Double>(){

            @Override
            public int size() {
                return numClasses;
            }

            @Override
            public Double get(int index) {
                Number priorProbability = hasPriorProbability.getPriorProbability(index);
                return LogitLink.logit(priorProbability.doubleValue());
            }
        };
        return result;
    }

    public static double logit(double x) {
        return Math.log(x / (1.0 - x));
    }
}

