/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neural_network;

import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.jpmml.converter.Schema;
import org.jpmml.python.HasArray;
import sklearn.SkLearnRegressor;
import sklearn.neural_network.MLPConstants;
import sklearn.neural_network.MultilayerPerceptronUtil;

public class MLPRegressor
extends SkLearnRegressor
implements MLPConstants {
    public MLPRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<HasArray> coefs = this.getCoefs();
        return MultilayerPerceptronUtil.getNumberOfFeatures(coefs);
    }

    public NeuralNetwork encodeModel(Schema schema) {
        String activation = this.getActivation();
        List<HasArray> coefs = this.getCoefs();
        List<HasArray> intercepts = this.getIntercepts();
        NeuralNetwork neuralNetwork = MultilayerPerceptronUtil.encodeNeuralNetwork(MiningFunction.REGRESSION, activation, coefs, intercepts, schema);
        return neuralNetwork;
    }

    public String getActivation() {
        return (String)this.getEnum("activation", arg_0 -> ((MLPRegressor)this).getString(arg_0), ENUM_ACTIVATION);
    }

    public List<HasArray> getCoefs() {
        return this.getArrayList("coefs_");
    }

    public List<HasArray> getIntercepts() {
        return this.getArrayList("intercepts_");
    }
}

