/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.SkLearnTransformer;
import sklearn.preprocessing.EncoderUtil;

public class LabelEncoder
extends SkLearnTransformer {
    public LabelEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<Object> classes = this.getClasses();
        return TypeUtil.getDataType(classes, (DataType)DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Object> classes = this.getClasses();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        encoder.toCategorical(feature.getName(), classes);
        return Collections.singletonList(EncoderUtil.encodeIndexFeature(this, feature, classes, null, null, DataType.INTEGER, encoder));
    }

    public List<Object> getClasses() {
        return this.getObjectArray("classes_");
    }
}

