/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.Scaler;

public class MinMaxScaler
extends Scaler {
    public MinMaxScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getScaleShape();
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Number> min = this.getMin();
        List<Number> scale = this.getScale();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, min, scale});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number minValue = min.get(i);
            Number scaleValue = scale.get(i);
            if (ValueUtil.isOne((Number)scaleValue) && ValueUtil.isZero((Number)minValue)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isOne((Number)scaleValue)) {
                expression = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)scaleValue)});
            }
            if (!ValueUtil.isZero((Number)minValue)) {
                expression = ExpressionUtil.createApply((String)"+", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)minValue)});
            }
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("minMaxScaler", continuousFeature), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public List<Number> getMin() {
        return this.getNumberArray("min_");
    }

    public List<Number> getScale() {
        return this.getNumberArray("scale_");
    }

    public int[] getScaleShape() {
        return this.getArrayShape("scale_", 1);
    }
}

