/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.preprocessing.BaseEncoder;
import sklearn.preprocessing.EncoderUtil;

public class OrdinalEncoder
extends BaseEncoder {
    private static final String HANDLEUNKNOWN_ERROR = "error";
    private static final String HANDLEUNKNOWN_USE_ENCODED_VALUE = "use_encoded_value";

    public OrdinalEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<List<Object>> categories = this.getCategories();
        TypeInfo dtype = this.getDType();
        String handleUnknown = this.getHandleUnknown();
        Number unknownValue = null;
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, features});
        if (handleUnknown != null && Objects.equals(HANDLEUNKNOWN_USE_ENCODED_VALUE, handleUnknown) && ValueUtil.isNaN((Object)(unknownValue = this.getUnknownValue()))) {
            unknownValue = null;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        DataType dataType = dtype.getDataType();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            ArrayList featureCategories = new ArrayList(categories.get(i));
            encoder.toCategorical(feature.getName(), EncoderUtil.filterCategories(featureCategories));
            if (handleUnknown != null) {
                InvalidValueTreatmentMethod invalidValueTreatmentMethod;
                switch (handleUnknown) {
                    case "error": {
                        invalidValueTreatmentMethod = InvalidValueTreatmentMethod.RETURN_INVALID;
                        break;
                    }
                    case "use_encoded_value": {
                        invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_IS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(handleUnknown);
                    }
                }
                EncoderUtil.addDecorator(feature, (Decorator)new InvalidValueDecorator(invalidValueTreatmentMethod, null));
            }
            result.add(EncoderUtil.encodeIndexFeature(this, feature, featureCategories, null, unknownValue, dataType, encoder));
        }
        return result;
    }

    public TypeInfo getDType() {
        return this.getDType("dtype", false);
    }

    public String getHandleUnknown() {
        return (String)this.getEnum("handle_unknown", arg_0 -> ((OrdinalEncoder)this).getOptionalString(arg_0), Arrays.asList(HANDLEUNKNOWN_ERROR, HANDLEUNKNOWN_USE_ENCODED_VALUE));
    }

    public Number getUnknownValue() {
        return this.getNumber("unknown_value");
    }
}

