/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.CategoricalDtype;
import sklearn.HasMultiType;
import sklearn2pmml.decoration.Domain;

public abstract class DiscreteDomain
extends Domain
implements HasMultiType {
    public DiscreteDomain(String module, String name) {
        super(module, name);
    }

    public abstract Feature encodeFeature(WildcardFeature var1, List<?> var2);

    @Override
    public DataType getDataType() {
        TypeInfo dtype = this.getDType();
        if (dtype != null) {
            return dtype.getDataType();
        }
        return DataType.STRING;
    }

    @Override
    public DataType getDataType(int index) {
        Boolean withData = this.getWithData();
        if (withData.booleanValue()) {
            List<List<Object>> dataValues = this.getDataValues();
            List<Object> values = dataValues.get(index);
            return TypeUtil.getDataType(values, (DataType)DataType.STRING);
        }
        return this.getDataType();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        features = super.encodeFeatures(features, encoder);
        TypeInfo dtype = this.getDType();
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        List<List<Object>> dataValues = null;
        if (withData.booleanValue()) {
            dataValues = this.getDataValues();
            ClassDictUtil.checkSize((int)features.size(), (Collection[])new Collection[]{dataValues});
        }
        Map<String, ?> counts = null;
        List<Object[]> discrStats = null;
        if (withStatistics.booleanValue()) {
            counts = this.getCounts();
            discrStats = this.getDiscrStats();
            ClassDictUtil.checkSize((int)features.size(), (Collection[])new Collection[]{discrStats});
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            WildcardFeature wildcardFeature = DiscreteDomain.asWildcardFeature(feature);
            List values = Collections.emptyList();
            if (withData.booleanValue()) {
                values = dataValues.get(i);
            } else if (dtype instanceof CategoricalDtype) {
                CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
                values = categoricalDtype.getValues();
            }
            feature = this.encodeFeature(wildcardFeature, values);
            if (withStatistics.booleanValue()) {
                UnivariateStats univariateStats = new UnivariateStats().setField(wildcardFeature.getName()).setCounts(DiscreteDomain.createCounts(DiscreteDomain.extractMap(counts, i))).setDiscrStats(DiscreteDomain.createDiscrStats(wildcardFeature.getDataType(), discrStats.get(i)));
                encoder.addUnivariateStats(univariateStats);
            }
            result.add(feature);
        }
        return result;
    }

    public List<List<Object>> getDataValues() {
        if (this.hasattr("data_values_")) {
            Object dataValues = this.getObject("data_values_");
            if (dataValues instanceof List) {
                return this.getArrayList("data_values_", Object.class);
            }
            return Collections.singletonList(this.getObjectArray("data_values_"));
        }
        return Collections.singletonList(this.getObjectArray("data_"));
    }

    public List<Object[]> getDiscrStats() {
        Object discrStats = this.getObject("discr_stats_");
        if (discrStats instanceof List) {
            return this.getTupleList("discr_stats_");
        }
        return Collections.singletonList(this.getTuple("discr_stats_"));
    }

    public static DiscrStats createDiscrStats(DataType dataType, Object[] objects) {
        List<?> values = DiscreteDomain.asArray(objects[0]);
        List counts = ValueUtil.asIntegers(DiscreteDomain.asArray(objects[1]));
        ClassDictUtil.checkSize((Collection[])new Collection[]{values, counts});
        DiscrStats discrStats = new DiscrStats().addArrays(new Array[]{PMMLUtil.createStringArray(DiscreteDomain.standardizeValues(dataType, values)), PMMLUtil.createIntArray((List)counts)});
        return discrStats;
    }
}

