/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Binarizer;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class BinarizerConverter
extends MultiFeatureConverter<Binarizer> {
    public BinarizerConverter(Binarizer transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        Binarizer transformer = (Binarizer)this.getTransformer();
        Double threshold = transformer.getThreshold();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        String[] inputCols = inputMode.getInputCols(transformer);
        for (int i = 0; i < inputCols.length; ++i) {
            String inputCol = inputCols[i];
            Feature feature = encoder.getOnlyFeature(inputCol);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            Apply apply = new Apply("if").addExpressions(new Expression[]{ExpressionUtil.createApply((String)"lessOrEqual", (Expression[])new Expression[]{continuousFeature.ref(), ExpressionUtil.createConstant((Number)threshold)})}).addExpressions(new Expression[]{ExpressionUtil.createConstant((Number)0.0), ExpressionUtil.createConstant((Number)1.0)});
            DerivedField derivedField = encoder.createDerivedField(BinarizerConverter.formatName(transformer, i), OpType.CATEGORICAL, DataType.DOUBLE, (Expression)apply);
            result.add((Feature)new IndexFeature((PMMLEncoder)encoder, (Field)derivedField, Arrays.asList(0.0, 1.0)));
        }
        return result;
    }
}

