/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.feature.InvalidCategoryTransformer;

public class InvalidCategoryTransformerConverter
extends MultiFeatureConverter<InvalidCategoryTransformer> {
    public InvalidCategoryTransformerConverter(InvalidCategoryTransformer transformer) {
        super(transformer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] inputCols;
        InvalidCategoryTransformer transformer = (InvalidCategoryTransformer)((Object)this.getTransformer());
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String inputCol : inputCols = inputMode.getInputCols(transformer)) {
            Feature feature = encoder.getOnlyFeature(inputCol);
            if (!(feature instanceof CategoricalFeature)) {
                throw new IllegalArgumentException();
            }
            CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
            Field field = categoricalFeature.getField();
            List values = categoricalFeature.getValues();
            if (values.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Object invalidCategory = values.get(values.size() - 1);
            if (!Objects.equals(invalidCategory, "-999") && !Objects.equals(invalidCategory, "__unknown")) {
                throw new IllegalArgumentException();
            }
            values = values.subList(0, values.size() - 1);
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                InvalidCategoryTransformerConverter.replaceDecorator(dataField, (Decorator)new InvalidValueDecorator(InvalidValueTreatmentMethod.AS_MISSING, null), encoder);
            } else {
                if (!(field instanceof DerivedField)) throw new IllegalArgumentException();
                DerivedField derivedField = (DerivedField)field;
                Apply apply = (Apply)derivedField.getExpression();
                List expressions = apply.getExpressions();
                if (expressions.isEmpty()) throw new IllegalArgumentException();
                Constant constant = (Constant)expressions.remove(expressions.size() - 1);
                if (!Objects.equals(invalidCategory, constant.getValue())) {
                    throw new IllegalArgumentException();
                }
            }
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, field, values));
        }
        return result;
    }

    private static void replaceDecorator(Field<?> field, Decorator decorator, SparkMLEncoder encoder) {
        List fieldDecorators;
        Map modelDecorators = encoder.getDecorators();
        ListMultimap decorators = (ListMultimap)modelDecorators.get(null);
        if (decorators != null && (fieldDecorators = decorators.get((Object)field.requireName())) != null && !fieldDecorators.isEmpty()) {
            Iterator it = fieldDecorators.iterator();
            while (it.hasNext()) {
                Decorator fieldDecorator = (Decorator)it.next();
                if (!Objects.equals(fieldDecorator.getClass(), decorator.getClass())) continue;
                it.remove();
            }
        }
        decorators.put((Object)field.requireName(), (Object)decorator);
    }
}

