/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.data;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jpmml.python.PythonObject;
import pandas.core.BlockManager;
import pandas.core.DataFrame;
import pandas.core.Index;
import pandas.core.Series;

public class ModelData
extends PythonObject {
    public ModelData(String module, String name) {
        super(module, name);
    }

    public List<String> getEndogNames() {
        Series origEndog = this.getOrigEndog();
        return Collections.singletonList(origEndog.getName());
    }

    public List<String> getExogNames() {
        DataFrame origExog = this.getOrigExog();
        BlockManager data = origExog.getData();
        Index columnAxis = data.getColumnAxis();
        return columnAxis.getValues();
    }

    public Cache getCache() {
        Map dict = this.getDict("_cache");
        Cache cache = new Cache(this.getPythonModule() + "." + this.getPythonName(), "_cache");
        cache.update(dict);
        return cache;
    }

    public Series getOrigEndog() {
        return (Series)this.get("orig_endog", Series.class);
    }

    public DataFrame getOrigExog() {
        return (DataFrame)this.get("orig_exog", DataFrame.class);
    }

    public class Cache
    extends PythonObject {
        public Cache(String module, String name) {
            super(module, name);
        }

        public boolean hasNames() {
            return this.hasattr("xnames") && this.hasattr("ynames");
        }

        public List<String> getXNames() {
            return this.getStringList("xnames");
        }

        public List<String> getYNames() {
            Object yNames = this.getObject("ynames");
            if (yNames instanceof String) {
                return Collections.singletonList((String)yNames);
            }
            return this.getStringList("ynames");
        }
    }
}

