/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.miscmodels;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.OrdinalLabel;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.statsmodels.StatsModelsEncoder;
import scipy.stats.RVContinuous;
import statsmodels.Model;

public class OrderedModel
extends Model {
    public OrderedModel(String module, String name) {
        super(module, name);
    }

    @Override
    public org.dmg.pmml.Model encodeModel(List<? extends Number> params, Schema schema) {
        RVContinuous distr = this.getDistr();
        Integer kExtra = this.getKExtra();
        Integer kLevels = this.getKLevels();
        Number offset = this.getOffset();
        if (kExtra != kLevels - 1) {
            throw new IllegalArgumentException();
        }
        ModelEncoder encoder = (ModelEncoder)schema.getEncoder();
        OrdinalLabel ordinalLabel = (OrdinalLabel)schema.getLabel();
        List features = schema.getFeatures();
        List<? extends Number> varsParams = params.subList(0, params.size() - (kLevels - 1));
        List<? extends Number> thParams = params.subList(params.size() - (kLevels - 1), params.size());
        ArrayList<Double> thresholds = new ArrayList<Double>();
        double prevThreshold = Double.NaN;
        for (int i = 0; i < thParams.size(); ++i) {
            double threshold = thParams.get(i).doubleValue();
            if (i > 0) {
                threshold = Math.exp(threshold) + prevThreshold;
            }
            thresholds.add(threshold);
            prevThreshold = threshold;
        }
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        RegressionModel firstRegressionModel = RegressionModelUtil.createRegression((List)features, varsParams, (Number)(offset != null ? (Number)offset : (Number)0.0), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (Schema)segmentSchema).setTargets(ModelUtil.createRescaleTargets((Number)-1.0, null, (ContinuousLabel)((ContinuousLabel)segmentSchema.getLabel())));
        OutputField linpredOutputField = ModelUtil.createPredictedField((String)"linpred", (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE);
        DerivedOutputField linpredField = encoder.createDerivedField((org.dmg.pmml.Model)firstRegressionModel, linpredOutputField, true);
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)linpredField);
        RegressionModel secondRegressionModel = RegressionModelUtil.createOrdinalClassification((Feature)feature, thresholds, (RegressionModel.NormalizationMethod)OrderedModel.parseNormalizationMethod(distr), (boolean)true, (Schema)schema);
        return MiningModelUtil.createModelChain(Arrays.asList(firstRegressionModel, secondRegressionModel), (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING);
    }

    @Override
    public Label encodeLabel(List<String> endogNames, StatsModelsEncoder encoder) {
        List labels = ValueUtil.asIntegers(this.getLabels());
        String endogName = (String)Iterables.getOnlyElement(endogNames);
        DataField dataField = encoder.createDataField(endogName, OpType.ORDINAL, DataType.INTEGER, labels);
        return new OrdinalLabel((Field)dataField);
    }

    @Override
    public List<Feature> encodeFeatures(List<String> exogNames, StatsModelsEncoder encoder) {
        Integer kLevels = this.getKLevels();
        exogNames = exogNames.subList(0, exogNames.size() - (kLevels - 1));
        return super.encodeFeatures(exogNames, encoder);
    }

    public RVContinuous getDistr() {
        return (RVContinuous)this.get("distr", RVContinuous.class);
    }

    public Integer getKLevels() {
        return this.getInteger("k_levels");
    }

    public List<Number> getLabels() {
        return this.getNumberArray("labels");
    }

    public Number getOffset() {
        return (Number)this.getOptionalScalar("offset");
    }

    private static RegressionModel.NormalizationMethod parseNormalizationMethod(RVContinuous rvContinuous) {
        String name = rvContinuous.getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        switch (name) {
            case "logistic": {
                return RegressionModel.NormalizationMethod.LOGIT;
            }
            case "norm": {
                return RegressionModel.NormalizationMethod.PROBIT;
            }
        }
        throw new IllegalArgumentException(name);
    }
}

