/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.client.ConnectionPool;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionPool<E extends AutoCloseable>
implements ConnectionPool<E> {
    private static Logger log = LoggerFactory.getLogger(AbstractConnectionPool.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    int size;
    private int lastUsedIndex = 0;
    final List<E> connections = new ArrayList();
    final AtomicBoolean closed = new AtomicBoolean(false);

    protected AbstractConnectionPool(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("the pool size should be >= 1, but it is " + size);
        }
        this.size = size;
    }

    @Override
    public synchronized boolean add(E connection) {
        if (debugEnabled) {
            log.debug("adding {} to {}", connection, (Object)this);
        }
        return this.connections.add(connection);
    }

    @Override
    public synchronized boolean remove(E connection) {
        if (debugEnabled) {
            log.debug("removing {} from {}", connection, (Object)this);
        }
        if (this.connections.remove(connection)) {
            if (this.lastUsedIndex >= this.connections.size() && this.lastUsedIndex > 0) {
                --this.lastUsedIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized E nextConnection() {
        if (this.connections.isEmpty()) {
            return null;
        }
        ++this.lastUsedIndex;
        this.lastUsedIndex %= this.connections.size();
        return (E)((AutoCloseable)this.connections.get(this.lastUsedIndex));
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.connections.isEmpty();
    }

    @Override
    public synchronized int connectionCount() {
        return this.connections.size();
    }

    @Override
    public synchronized List<E> getConnections() {
        return new ArrayList<E>(this.connections);
    }

    @Override
    public synchronized Iterator<E> iterator() {
        return this.connections.iterator();
    }

    synchronized E getConnection(int i) {
        return (E)((AutoCloseable)this.connections.get(i));
    }

    @Override
    public synchronized int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            List<E> connections = this.getConnections();
            for (AutoCloseable connection : connections) {
                try {
                    if (connection == null) continue;
                    connection.close();
                }
                catch (Exception e) {
                    String format = "error while closing connection {} : {}";
                    if (debugEnabled) {
                        log.debug("error while closing connection {} : {}", (Object)connection, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        continue;
                    }
                    log.warn("error while closing connection {} : {}", (Object)connection, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
            }
            AbstractConnectionPool abstractConnectionPool = this;
            synchronized (abstractConnectionPool) {
                this.connections.clear();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append(", size=").append(this.size);
        sb.append(", connectionCount=").append(this.connectionCount());
        sb.append(']');
        return sb.toString();
    }
}

