/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jppf.client.AbstractJPPFClient;
import org.jppf.client.ClassLoaderRegistrationHandler;
import org.jppf.client.ClientConfigDriverDiscovery;
import org.jppf.client.ClientDriverDiscoveryListener;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.JPPFMulticastReceiverThread;
import org.jppf.client.JobManager;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ClientQueueEvent;
import org.jppf.client.event.ClientQueueListener;
import org.jppf.client.event.ConnectionPoolListener;
import org.jppf.discovery.ClientConnectionPoolInfo;
import org.jppf.discovery.ClientDriverDiscovery;
import org.jppf.discovery.DriverDiscovery;
import org.jppf.discovery.DriverDiscoveryHandler;
import org.jppf.discovery.DriverDiscoveryListener;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManagement;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManager;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.policy.PolicyParser;
import org.jppf.node.policy.PolicyUtils;
import org.jppf.persistence.JPPFDatasourceFactory;
import org.jppf.queue.QueueEvent;
import org.jppf.queue.QueueListener;
import org.jppf.startup.JPPFClientStartupSPI;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.HostIP;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.concurrent.JPPFThreadFactory;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.jppf.utils.hooks.HookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericClient
extends AbstractJPPFClient
implements QueueListener<ClientJob, ClientJob, ClientTaskBundle> {
    private static Logger log = LoggerFactory.getLogger(AbstractGenericClient.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    static final String VALUE_JPPF_DISCOVERY = "jppf_discovery";
    private ThreadPoolExecutor executor;
    private JPPFMulticastReceiverThread receiverThread;
    private JobManager jobManager;
    private final ClassLoaderRegistrationHandler classLoaderRegistrationHandler;
    private final List<ClientQueueListener> queueListeners = new CopyOnWriteArrayList<ClientQueueListener>();
    final DriverDiscoveryHandler<ClientConnectionPoolInfo> discoveryHandler = new DriverDiscoveryHandler(ClientDriverDiscovery.class);
    private ClientDriverDiscoveryListener discoveryListener;
    JPPFBundlerFactory bundlerFactory;
    LoadBalancerPersistenceManager loadBalancerPersistenceManager;
    final AtomicReference<ExecutionPolicy> defaultPolicy = new AtomicReference<Object>(null);
    final AtomicReference<ExecutionPolicy> defaultClientPolicy = new AtomicReference<Object>(null);
    private boolean sysoutEnabled;

    public AbstractGenericClient(String uuid, TypedProperties configuration, ConnectionPoolListener ... listeners) {
        super(uuid);
        this.classLoaderRegistrationHandler = new ClassLoaderRegistrationHandler();
        if (listeners != null && listeners.length > 0) {
            for (ConnectionPoolListener listener : listeners) {
                if (listener == null) continue;
                this.addConnectionPoolListener(listener);
            }
        }
        this.discoveryListener = new ClientDriverDiscoveryListener(this);
        this.init(configuration);
    }

    protected void init(TypedProperties configuration) {
        if (debugEnabled) {
            log.debug("initializing client");
        }
        this.closed.set(false);
        this.resetting.set(false);
        this.config = this.initConfig(configuration);
        try {
            Map result = JPPFDatasourceFactory.getInstance().createDataSources((Properties)this.config);
            log.info("created client-side datasources: {}", result.keySet());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.bundlerFactory = new JPPFBundlerFactory(JPPFBundlerFactory.Defaults.CLIENT, this.config);
        this.loadBalancerPersistenceManager = new LoadBalancerPersistenceManager(this.bundlerFactory);
        try {
            HookFactory.registerSPIMultipleHook(JPPFClientStartupSPI.class, null, null).invoke("run", new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int coreThreads = Runtime.getRuntime().availableProcessors();
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(coreThreads, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, queue, (ThreadFactory)new JPPFThreadFactory("JPPF Client"));
        this.executor.allowCoreThreadTimeOut(true);
        if (this.jobManager == null) {
            this.jobManager = this.createJobManager();
        }
        this.defaultPolicy.set(this.retrieveDefaultPolicy((JPPFProperty<String>)JPPFProperties.JOB_SLA_DEFAULT_POLICY));
        this.defaultClientPolicy.set(this.retrieveDefaultPolicy((JPPFProperty<String>)JPPFProperties.JOB_CLIENT_SLA_DEFAULT_POLICY));
        ThreadUtils.startThread(() -> this.initPools(this.config), (String)"InitPools");
    }

    private ExecutionPolicy retrieveDefaultPolicy(JPPFProperty<String> prop) {
        String policyXML = PolicyUtils.resolvePolicy((TypedProperties)this.config, (String)prop.getName());
        if (policyXML != null) {
            try {
                return PolicyParser.parsePolicy((String)policyXML.trim());
            }
            catch (Exception e) {
                log.warn("failed to parse execution policy for {}, with content = {}\n{}", new Object[]{prop.getName(), policyXML, ExceptionUtils.getStackTrace((Throwable)e)});
            }
        }
        return null;
    }

    TypedProperties initConfig(Object configuration) {
        if (configuration instanceof TypedProperties) {
            return (TypedProperties)configuration;
        }
        return JPPFConfiguration.getProperties();
    }

    @Override
    protected void initPools(TypedProperties config) {
        if (debugEnabled) {
            log.debug("initializing connections");
        }
        this.sysoutEnabled = (Boolean)config.get(JPPFProperties.CLIENT_SYSOUT_ENABLED);
        if (((Boolean)config.get(JPPFProperties.LOCAL_EXECUTION_ENABLED)).booleanValue()) {
            if (this.sysoutEnabled) {
                System.out.println("local execution enabled");
            }
            this.setLocalExecutionEnabled(true);
        }
        this.discoveryHandler.register((DriverDiscoveryListener)this.discoveryListener.open()).start();
        if (((Boolean)config.get(JPPFProperties.REMOTE_EXECUTION_ENABLED)).booleanValue()) {
            this.addDriverDiscovery(new ClientConfigDriverDiscovery(config));
        }
    }

    void newConnectionPool(final ClientConnectionPoolInfo info) {
        if (debugEnabled) {
            log.debug("new connection pool: {}", (Object)info.getName());
        }
        final int size = info.getPoolSize() > 0 ? info.getPoolSize() : 1;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JPPFConnectionPool pool = new JPPFConnectionPool((JPPFClient)AbstractGenericClient.this, AbstractGenericClient.this.poolSequence.incrementAndGet(), info);
                pool.setDriverPort(info.getPort());
                CollectionMap collectionMap = AbstractGenericClient.this.pools;
                synchronized (collectionMap) {
                    AbstractGenericClient.this.pools.putValue((Object)info.getPriority(), (Object)pool);
                }
                HostIP hostIP = new HostIP(info.getHost(), info.getHost());
                if (((Boolean)AbstractGenericClient.this.getConfig().get(JPPFProperties.RESOLVE_ADDRESSES)).booleanValue()) {
                    hostIP = NetworkUtils.getHostIP((String)info.getHost());
                }
                if (debugEnabled) {
                    log.debug("'{}' was resolved into '{}'", (Object)info.getHost(), (Object)hostIP.hostName());
                }
                pool.setDriverHostIP(hostIP);
                AbstractGenericClient.this.fireConnectionPoolAdded(pool);
                for (int i = 1; i <= size; ++i) {
                    if (AbstractGenericClient.this.isClosed()) {
                        return;
                    }
                    AbstractGenericClient.this.submitNewConnection(pool);
                }
                pool.initHeartbeat();
            }
        };
        this.executor.execute(r);
    }

    void submitNewConnection(JPPFConnectionPool pool) {
        JPPFClientConnectionImpl c = this.createConnection(pool.getName() + "-" + pool.nextSequence(), pool);
        this.newConnection(c);
    }

    abstract JPPFClientConnectionImpl createConnection(String var1, JPPFConnectionPool var2);

    @Override
    void newConnection(JPPFClientConnectionImpl c) {
        if (this.isClosed()) {
            return;
        }
        log.info("connection [" + c.getName() + "] created");
        c.addClientConnectionStatusListener(this);
        c.submitInitialization();
        this.fireConnectionAdded(c);
        if (debugEnabled) {
            log.debug("end of of newConnection({})", (Object)c.getName());
        }
    }

    @Override
    void connectionFailed(JPPFClientConnection connection) {
        if (debugEnabled) {
            log.debug("Connection [{}] {}", (Object)connection.getName(), (Object)connection.getStatus());
        }
        JPPFConnectionPool pool = connection.getConnectionPool();
        connection.close();
        boolean poolRemoved = this.removeClientConnection(connection);
        this.fireConnectionRemoved(connection);
        if (poolRemoved) {
            ClientConnectionPoolInfo info;
            this.fireConnectionPoolRemoved(pool);
            if (this.receiverThread != null) {
                this.receiverThread.removeConnectionInformation(connection.getDriverUuid());
            }
            if ((info = pool.getDiscoveryInfo()) != null) {
                boolean b = this.discoveryListener.onPoolRemoved(info);
                if (debugEnabled) {
                    log.debug("removal of {} = {}", (Object)info, (Object)b);
                }
            }
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    void close(boolean reset) {
        try {
            log.info("closing JPPF client with uuid={}, PID={}", (Object)this.getUuid(), (Object)SystemUtils.getPID());
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (debugEnabled) {
                log.debug("closing discovery handler");
            }
            this.discoveryListener.close();
            this.discoveryHandler.stop();
            if (debugEnabled) {
                log.debug("closing broadcast receiver");
            }
            if (this.receiverThread != null) {
                this.receiverThread.close();
                this.receiverThread = null;
            }
            if (debugEnabled) {
                log.debug("unregistering startup classes");
            }
            HookFactory.unregister(JPPFClientStartupSPI.class);
            if (this.jobManager != null) {
                if (reset) {
                    if (debugEnabled) {
                        log.debug("resetting job manager");
                    }
                    this.jobManager.reset();
                } else {
                    if (debugEnabled) {
                        log.debug("closing job manager");
                    }
                    this.jobManager.close();
                    this.jobManager = null;
                }
            }
            if (debugEnabled) {
                log.debug("closing executor");
            }
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor = null;
            }
            if (debugEnabled) {
                log.debug("clearing registered class loaders");
            }
            this.classLoaderRegistrationHandler.close();
            super.close();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
    }

    public boolean isLocalExecutionEnabled() {
        JobManager jobManager = this.getJobManager();
        return jobManager != null && jobManager.isLocalExecutionEnabled();
    }

    public void setLocalExecutionEnabled(boolean localExecutionEnabled) {
        JobManager jobManager = this.getJobManager();
        if (jobManager != null) {
            jobManager.setLocalExecutionEnabled(localExecutionEnabled);
        }
    }

    public boolean hasAvailableConnection() {
        JobManager jobManager = this.getJobManager();
        return jobManager != null && jobManager.hasAvailableConnection();
    }

    @Override
    public void statusChanged(ClientConnectionStatusEvent event) {
        ClientConnectionStatusListener listener;
        super.statusChanged(event);
        JobManager jobManager = this.getJobManager();
        if (jobManager != null && (listener = jobManager.getClientConnectionStatusListener()) != null) {
            listener.statusChanged(event);
        }
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    abstract JobManager createJobManager();

    public boolean cancelJob(String jobId) throws Exception {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobUUID is blank");
        }
        if (debugEnabled) {
            log.debug("request to cancel job with uuid=" + jobId);
        }
        return this.getJobManager().cancelJob(jobId);
    }

    public Collection<ClassLoader> getRegisteredClassLoaders(String uuid) {
        return this.classLoaderRegistrationHandler.getRegisteredClassLoaders(uuid);
    }

    public ClassLoader registerClassLoader(ClassLoader cl, String uuid) {
        return this.classLoaderRegistrationHandler.registerClassLoader(cl, uuid);
    }

    public void unregisterClassLoaders(String uuid) {
        this.classLoaderRegistrationHandler.unregister(uuid);
    }

    public void addClientQueueListener(ClientQueueListener listener) {
        this.queueListeners.add(listener);
    }

    public void removeClientQueueListener(ClientQueueListener listener) {
        this.queueListeners.remove(listener);
    }

    protected void fireQueueEvent(QueueEvent<ClientJob, ClientJob, ClientTaskBundle> qEvent, boolean jobAdded) {
        ClientQueueEvent event = new ClientQueueEvent((JPPFClient)this, ((ClientJob)qEvent.getJob()).getJob(), (JPPFPriorityQueue)qEvent.getQueue());
        if (jobAdded) {
            for (ClientQueueListener listener : this.queueListeners) {
                listener.jobAdded(event);
            }
        } else {
            for (ClientQueueListener listener : this.queueListeners) {
                listener.jobRemoved(event);
            }
        }
    }

    public void bundleAdded(QueueEvent<ClientJob, ClientJob, ClientTaskBundle> event) {
        this.fireQueueEvent(event, true);
    }

    public void bundleRemoved(QueueEvent<ClientJob, ClientJob, ClientTaskBundle> event) {
        this.fireQueueEvent(event, false);
    }

    public LoadBalancerPersistenceManagement getLoadBalancerPersistenceManagement() {
        return this.loadBalancerPersistenceManager;
    }

    public void addDriverDiscovery(ClientDriverDiscovery discovery) {
        this.discoveryHandler.addDiscovery((DriverDiscovery)discovery);
    }

    public boolean isSysoutEnabled() {
        return this.sysoutEnabled;
    }
}

