/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jppf.client.JPPFClient;
import org.jppf.client.JobResults;
import org.jppf.client.JobStatus;
import org.jppf.client.JobStatusHandler;
import org.jppf.client.event.JobListener;
import org.jppf.client.event.JobStatusEvent;
import org.jppf.client.event.JobStatusListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JPPFJobMetadata;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.Task;
import org.jppf.utils.JPPFUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFJob<J extends AbstractJPPFJob<J>>
implements Serializable,
JPPFDistributedJob,
JobStatusHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final long serialVersionUID = 1L;
    final List<Task<?>> tasks = new ArrayList();
    DataProvider dataProvider;
    boolean blocking = true;
    String name;
    final String uuid;
    JobSLA jobSLA = new JobSLA();
    JobClientSLA jobClientSLA = new JobClientSLA();
    JobMetadata jobMetadata = new JPPFJobMetadata();
    final JobResults results = new JobResults();
    transient List<JobListener> listeners = new CopyOnWriteArrayList<JobListener>();
    transient JobPersistence<?> persistenceManager;
    transient JPPFClient client;
    transient AtomicBoolean cancelled = new AtomicBoolean(false);
    transient AtomicBoolean cancelling = new AtomicBoolean(false);
    private AtomicReference<JobStatus> status = new AtomicReference<JobStatus>(JobStatus.SUBMITTED);
    private transient List<JobStatusListener> statusListeners = new ArrayList<JobStatusListener>();
    boolean taskGraph;

    public AbstractJPPFJob() {
        this(JPPFUuid.normalUUID());
    }

    public AbstractJPPFJob(String jobUuid) {
        this.name = this.uuid = jobUuid == null ? JPPFUuid.normalUUID() : jobUuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public J setName(String name) {
        this.name = name;
        this.results.setJobName(name);
        return (J)this;
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public int hashCode() {
        return 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractJPPFJob)) {
            return false;
        }
        AbstractJPPFJob other = (AbstractJPPFJob)obj;
        return this.uuid == null ? other.uuid == null : this.uuid.equals(other.uuid);
    }

    public JobResults getResults() {
        return this.results;
    }

    public int executedTaskCount() {
        return this.results.size();
    }

    public int unexecutedTaskCount() {
        return this.tasks.size() - this.results.size();
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public J setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        return (J)this;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public J setBlocking(boolean blocking) {
        this.blocking = blocking;
        return (J)this;
    }

    public JobSLA getSLA() {
        return this.jobSLA;
    }

    public JobClientSLA getClientSLA() {
        return this.jobClientSLA;
    }

    public JobMetadata getMetadata() {
        return this.jobMetadata;
    }

    public void setSLA(JobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    public void setClientSLA(JobClientSLA jobClientSLA) {
        this.jobClientSLA = jobClientSLA;
    }

    public void setMetadata(JobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    protected Object readResolve() {
        this.listeners = new LinkedList<JobListener>();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.name);
        sb.append(", uuid=").append(this.uuid);
        sb.append(", blocking=").append(this.blocking);
        sb.append(", nbTasks=").append(this.tasks.size());
        sb.append(", nbResults=").append(this.results.size());
        sb.append(", hasGraph=").append(this.taskGraph);
        sb.append(']');
        return sb.toString();
    }

    public AtomicBoolean getCancelledFlag() {
        return this.cancelled;
    }

    @Override
    public JobStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void setStatus(JobStatus newStatus) {
        if (this.status.get() != newStatus) {
            if (debugEnabled) {
                log.debug("job [" + this.uuid + "] status changing from '" + this.status + "' to '" + (Object)((Object)newStatus) + "'");
            }
            this.status.set(newStatus);
            this.fireStatusChangeEvent(newStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobStatusListener(JobStatusListener listener) {
        List<JobStatusListener> list = this.statusListeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("job [" + this.uuid + "] adding status listener " + listener);
            }
            if (listener != null) {
                this.statusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobStatusListener(JobStatusListener listener) {
        List<JobStatusListener> list = this.statusListeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("job [" + this.uuid + "] removing status listener " + listener);
            }
            if (listener != null) {
                this.statusListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStatusChangeEvent(JobStatus newStatus) {
        List<JobStatusListener> list = this.statusListeners;
        synchronized (list) {
            if (debugEnabled) {
                log.debug("job [" + this.uuid + "] fire status changed event for '" + (Object)((Object)newStatus) + "'");
            }
            if (!this.statusListeners.isEmpty()) {
                JobStatusEvent event = new JobStatusEvent(this.uuid, newStatus);
                for (JobStatusListener listener : this.statusListeners) {
                    listener.jobStatusChanged(event);
                }
            }
        }
        this.results.wakeUp();
    }

    public AtomicBoolean getCancellingFlag() {
        return this.cancelling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void await(long timeout, boolean raiseTimeoutException) throws TimeoutException, InterruptedException {
        long start = System.nanoTime();
        int nbTasks = this.tasks.size();
        JobResults jobResults = this.results;
        synchronized (jobResults) {
            long elapsed;
            while (!((elapsed = (System.nanoTime() - start) / 1000000L) >= timeout || this.results.size() >= nbTasks && this.getStatus().isDone())) {
                this.results.wait(timeout - elapsed);
            }
            if (!this.getStatus().isDone() && raiseTimeoutException) {
                throw new TimeoutException("timeout expired");
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.statusListeners = new ArrayList<JobStatusListener>();
        this.listeners = new CopyOnWriteArrayList<JobListener>();
        this.cancelled = new AtomicBoolean(false);
        this.cancelling = new AtomicBoolean(false);
    }
}

