/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassLoaderRegistrationHandler
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(ClassLoaderRegistrationHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final CollectionMap<String, ClassLoader> classLoaderRegistrations = new SetHashMap();

    ClassLoaderRegistrationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ClassLoader> getRegisteredClassLoaders(String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid is null");
        }
        CollectionMap<String, ClassLoader> collectionMap = this.classLoaderRegistrations;
        synchronized (collectionMap) {
            ArrayList<ClassLoader> c = this.classLoaderRegistrations.getValues((Object)uuid);
            if (c == null || c.isEmpty()) {
                if (debugEnabled) {
                    log.debug("job '{}' is no longer registered, looking for an alternate class loader", (Object)uuid);
                }
                ClassLoader rcl = null;
                Iterator it = this.classLoaderRegistrations.iterator();
                if (it.hasNext()) {
                    rcl = (ClassLoader)it.next();
                } else {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    rcl = cl;
                }
                if (c == null) {
                    c = new ArrayList<ClassLoader>();
                }
                c.add(rcl);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader registerClassLoader(ClassLoader cl, String uuid) {
        if (cl == null) {
            throw new IllegalArgumentException("cl is null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("uuid is null");
        }
        CollectionMap<String, ClassLoader> collectionMap = this.classLoaderRegistrations;
        synchronized (collectionMap) {
            this.classLoaderRegistrations.putValue((Object)uuid, (Object)cl);
        }
        if (debugEnabled) {
            log.debug("registered {}", (Object)cl);
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("registeredClassLoader is null");
        }
        if (debugEnabled) {
            log.debug("unregistering {}", (Object)uuid);
        }
        CollectionMap<String, ClassLoader> collectionMap = this.classLoaderRegistrations;
        synchronized (collectionMap) {
            this.classLoaderRegistrations.removeKey((Object)uuid);
        }
    }

    @Override
    public void close() {
        this.classLoaderRegistrations.clear();
    }
}

