/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.utils.collections.SoftReferenceValuesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathCache {
    private static final Logger log = LoggerFactory.getLogger(ClasspathCache.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private static final ClasspathCache instance = new ClasspathCache();
    private final Map<ClassLoader, Map<String, byte[]>> cache = new SoftReferenceValuesMap();
    private final AtomicLong nbRequests = new AtomicLong(0L);
    private final AtomicLong nbHits = new AtomicLong(0L);

    private ClasspathCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(ClassLoader loader, String path) {
        try {
            Map<String, byte[]> resources;
            this.nbRequests.incrementAndGet();
            if (loader == null || path == null) {
                byte[] byArray = null;
                return byArray;
            }
            Map<Object, Object> map = this.cache;
            synchronized (map) {
                resources = this.cache.get(loader);
            }
            if (resources != null) {
                map = resources;
                synchronized (map) {
                    byte[] result = resources.get(path);
                    if (result != null) {
                        this.nbHits.incrementAndGet();
                    }
                    byte[] byArray = result;
                    return byArray;
                }
            }
            map = null;
            return map;
        }
        finally {
            if (debugEnabled) {
                log.debug(this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ClassLoader loader, String path, byte[] resource) {
        SoftReferenceValuesMap resources;
        if (loader == null || path == null || resource == null) {
            return;
        }
        SoftReferenceValuesMap softReferenceValuesMap = this.cache;
        synchronized (softReferenceValuesMap) {
            resources = this.cache.get(loader);
            if (resources == null) {
                resources = new SoftReferenceValuesMap();
                this.cache.put(loader, (Map<String, byte[]>)resources);
            }
        }
        softReferenceValuesMap = resources;
        synchronized (softReferenceValuesMap) {
            resources.put(path, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ClassLoader, Map<String, byte[]>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheSize() {
        long size = 0L;
        Map<ClassLoader, Map<String, byte[]>> map = this.cache;
        synchronized (map) {
            for (ClassLoader cl : this.cache.keySet()) {
                Map<String, byte[]> resources = this.cache.get(cl);
                if (resources == null) continue;
                size += (long)resources.size();
            }
        }
        return size;
    }

    public static ClasspathCache getInstance() {
        return instance;
    }

    public String toString() {
        long total = this.nbRequests.get();
        long hits = this.nbHits.get();
        return String.format("%s[requests=%,d; misses=%,d; hits=%,d; size=%,d]", this.getClass().getSimpleName(), total, hits, total - hits, this.getCacheSize());
    }
}

