/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jppf.client.JPPFMulticastReceiverThread;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.discovery.ClientConnectionPoolInfo;
import org.jppf.discovery.ClientDriverDiscovery;
import org.jppf.discovery.DriverConnectionInfo;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigDriverDiscovery
extends ClientDriverDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ClientConfigDriverDiscovery.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final TypedProperties config;
    private JPPFMulticastReceiverThread receiverThread;

    public ClientConfigDriverDiscovery(TypedProperties config) {
        this.config = config;
    }

    public void discover() throws InterruptedException {
        try {
            boolean initPeers;
            if (((Boolean)this.config.get(JPPFProperties.DISCOVERY_ENABLED)).booleanValue()) {
                int priority = (Integer)this.config.get(JPPFProperties.DISCOVERY_PRIORITY);
                boolean acceptMultipleInterfaces = (Boolean)this.config.get(JPPFProperties.DISCOVERY_ACCEPT_MULTIPLE_INTERFACES);
                boolean heartbeatEnabled = (Boolean)this.config.get(JPPFProperties.RECOVERY_ENABLED);
                if (debugEnabled) {
                    log.debug("initializing connections from discovery with priority = {} and acceptMultipleInterfaces = {}", (Object)priority, (Object)acceptMultipleInterfaces);
                }
                int ssl = ((Boolean)this.config.get(JPPFProperties.SSL_ENABLED)).booleanValue() ? 1 : 0;
                this.receiverThread = new JPPFMulticastReceiverThread((arg_0, arg_1) -> this.lambda$discover$0(ssl != 0, priority, heartbeatEnabled, arg_0, arg_1), new IPFilter(this.config), acceptMultipleInterfaces);
                ThreadUtils.startDaemonThread((Runnable)this.receiverThread, (String)"ReceiverThread");
                initPeers = false;
            } else {
                this.receiverThread = null;
                initPeers = true;
            }
            if (debugEnabled) {
                log.debug("looking for peers in the configuration");
            }
            String[] names = (String[])this.config.get(JPPFProperties.DRIVERS);
            if (debugEnabled) {
                log.debug("list of drivers: {}", Arrays.asList(names));
            }
            for (String name : names) {
                initPeers |= "jppf_discovery".equals(name);
            }
            if (debugEnabled) {
                log.debug("initPeers = {}", (Object)initPeers);
            }
            if (initPeers) {
                ArrayList<ClientConnectionPoolInfo> infoList = new ArrayList<ClientConnectionPoolInfo>(names.length);
                for (String name : names) {
                    if ("jppf_discovery".equals(name)) continue;
                    boolean ssl = (Boolean)this.config.get(JPPFProperties.PARAM_SERVER_SSL_ENABLED, new String[]{name});
                    String host = (String)this.config.get(JPPFProperties.PARAM_SERVER_HOST, new String[]{name});
                    int port = (Integer)this.config.get(JPPFProperties.PARAM_SERVER_PORT, new String[]{name});
                    int priority = (Integer)this.config.get(JPPFProperties.PARAM_PRIORITY, new String[]{name});
                    int poolSize = (Integer)this.config.get(JPPFProperties.PARAM_POOL_SIZE, new String[]{name});
                    int jmxPoolSize = (Integer)this.config.get(JPPFProperties.PARAM_JMX_POOL_SIZE, new String[]{name});
                    boolean heartbeatEnabled = (Boolean)this.config.get(JPPFProperties.PARAM_RECOVERY_ENABLED, new String[]{name});
                    int maxJobs = (Integer)this.config.get(JPPFProperties.PARAM_MAX_JOBS, new String[]{name});
                    ClientConnectionPoolInfo ccpi = new ClientConnectionPoolInfo(name, ssl, host, port, priority, poolSize, jmxPoolSize, heartbeatEnabled, maxJobs);
                    if (debugEnabled) {
                        log.debug("found pool definition in the configuration: {}", (Object)ccpi);
                    }
                    infoList.add(ccpi);
                }
                if (debugEnabled) {
                    log.debug("found {} pool definitions in the configuration", (Object)infoList.size());
                }
                Collections.sort(infoList, (o1, o2) -> {
                    int p2;
                    int p1 = o1.getPriority();
                    return p1 > (p2 = o2.getPriority()) ? -1 : (p1 < p2 ? 1 : 0);
                });
                for (ClientConnectionPoolInfo poolInfo : infoList) {
                    this.newConnection((DriverConnectionInfo)poolInfo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.receiverThread != null) {
            this.receiverThread.close();
            this.receiverThread = null;
        }
    }

    private /* synthetic */ void lambda$discover$0(boolean ssl, int priority, boolean heartbeatEnabled, String name, JPPFConnectionInformation info) {
        if (info.hasValidPort(ssl)) {
            int poolSize = (Integer)this.config.get(JPPFProperties.POOL_SIZE);
            int jmxPoolSize = (Integer)this.config.get(JPPFProperties.JMX_POOL_SIZE);
            int maxJobs = (Integer)this.config.get(JPPFProperties.MAX_JOBS);
            this.newConnection((DriverConnectionInfo)new ClientConnectionPoolInfo(name, ssl, info.host, info.getValidPort(ssl), priority, poolSize, jmxPoolSize, heartbeatEnabled, maxJobs));
        } else {
            String type = ssl ? "secure" : "plain";
            log.warn("cannot fulfill a {} connection request to {}:{} because the host does not expose this port as a {} port", new Object[]{type, info.host, info.getValidPort(ssl), type});
        }
    }
}

