/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.balancer.JobManagerClient;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInitializer
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ConnectionInitializer.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private JPPFClientConnectionImpl connection;

    public ConnectionInitializer(JPPFClientConnectionImpl connection) {
        this.connection = connection;
    }

    @Override
    public void run() {
        if (debugEnabled) {
            log.debug("initializing driver connection '" + this.connection + '\'');
        }
        try {
            ((JobManagerClient)this.connection.getClient().getJobManager()).addConnection(this.connection);
            this.connection.init();
        }
        finally {
            this.connection.initializing.set(false);
        }
    }
}

