/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.JPPFError;
import org.jppf.client.BaseJPPFClientConnection;
import org.jppf.client.ClassServerDelegateImpl;
import org.jppf.client.ConnectionInitializer;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClientConnectionImpl
extends BaseJPPFClientConnection {
    private static Logger log = LoggerFactory.getLogger(JPPFClientConnectionImpl.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static AtomicLong instanceCount = new AtomicLong(0L);
    private final List<ClientConnectionStatusListener> listeners = new CopyOnWriteArrayList<ClientConnectionStatusListener>();
    String displayName;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean initializing = new AtomicBoolean(false);
    final long instanceNumber = instanceCount.incrementAndGet();

    JPPFClientConnectionImpl(JPPFClient client, String name, JPPFConnectionPool pool) {
        super(pool);
        if (client.isClosed()) {
            if (debugEnabled) {
                log.debug("error: initializing connection {} while client is closed", (Object)name);
            }
            throw new IllegalStateException("error: initializing connection " + name + " while client is closed");
        }
        this.connectionUuid = client.getUuid() + '_' + connectionCount.incrementAndGet();
        this.configure(pool.getDriverUuid(), name);
        this.displayName = name + '[' + this.getHost() + ':' + this.getPort() + "] (id=" + this.instanceNumber + ")";
        pool.add(this);
    }

    @Override
    public void init() {
        try {
            if (this.isClosed()) {
                log.warn("attempting to init closed " + this.getClass().getSimpleName() + ", aborting");
                return;
            }
            if (this.delegate == null) {
                this.delegate = new ClassServerDelegateImpl(this, this.pool.getClient().getUuid(), this.getHost(), this.getPort());
            }
            if (this.taskServerConnection == null) {
                this.taskServerConnection = new TaskServerConnectionHandler(this, this.getHost(), this.getPort());
            }
            this.setStatus(JPPFClientConnectionStatus.CONNECTING);
            this.connect();
            this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            JPPFClientConnectionStatus status = this.getStatus();
            if (debugEnabled) {
                log.debug("connection [" + this.name + "] status=" + (Object)((Object)status));
            }
            if (this.pool.getClient().isClosed()) {
                this.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.setStatus(JPPFClientConnectionStatus.FAILED);
        }
        catch (JPPFError e) {
            this.setStatus(JPPFClientConnectionStatus.FAILED);
            throw e;
        }
    }

    private void connect() throws Exception {
        this.delegate.init();
        if (!this.delegate.isClosed()) {
            ThreadUtils.startThread((Runnable)this.delegate, (String)this.delegate.getName());
            this.taskServerConnection.init();
        }
    }

    @Override
    SocketInitializer createSocketInitializer() {
        return SocketInitializer.Factory.newInstance((TypedProperties)this.pool.getClient().getConfig());
    }

    void configure(String uuid, String name) {
        this.pool.setDriverUuid(uuid);
        this.name = name;
        this.displayName = name;
    }

    @Override
    public int getPriority() {
        return this.pool.getPriority();
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return (JPPFClientConnectionStatus)((Object)this.status.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        Object object = this.statusChangeLock;
        synchronized (object) {
            JPPFClientConnectionStatus oldStatus = this.getStatus();
            if (debugEnabled) {
                log.debug("connection '" + this.name + "' attempting to change status to " + (Object)((Object)status));
            }
            if (status != oldStatus) {
                if (debugEnabled) {
                    log.debug("connection '" + this.name + "' status changing from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)status));
                }
                this.status.set(status);
                this.fireStatusChanged(oldStatus);
            }
        }
    }

    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    void fireStatusChanged(JPPFClientConnectionStatus oldStatus) {
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        for (ClientConnectionStatusListener listener : this.listeners) {
            listener.statusChanged(event);
        }
    }

    public String toString() {
        return this.displayName + " : " + this.status + " (" + SystemUtils.getSystemIdentityName((Object)this) + ")";
    }

    @Override
    public boolean isSSLEnabled() {
        return this.pool.isSslEnabled();
    }

    @Override
    public JPPFSystemInformation getSystemInfo() {
        return this.pool.getSystemInfo();
    }

    @Override
    TaskBundle sendHandshakeJob() throws Exception {
        TaskBundle bundle = super.sendHandshakeJob();
        this.pool.setSystemInfo((JPPFSystemInformation)bundle.getParameter((Object)BundleParameter.SYSTEM_INFO_PARAM));
        this.pool.setDriverUuid((String)bundle.getParameter((Object)BundleParameter.DRIVER_UUID_PARAM));
        return bundle;
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (debugEnabled) {
            log.debug("closing connection {}", (Object)this);
        }
        if (!this.getStatus().isTerminatedStatus()) {
            this.setStatus(JPPFClientConnectionStatus.CLOSED);
        }
        this.listeners.clear();
        try {
            this.sendCloseConnectionCommand();
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug('[' + this.name + "] " + e.getMessage(), (Throwable)e);
            }
            log.error('[' + this.name + "] " + e.getMessage());
        }
        try {
            if (debugEnabled) {
                log.debug("closing task server connection " + this);
            }
            if (this.taskServerConnection != null) {
                this.taskServerConnection.close();
            }
            if (debugEnabled) {
                log.debug("closing class server connection " + this);
            }
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug('[' + this.name + "] " + e.getMessage(), (Throwable)e);
            }
            log.error('[' + this.name + "] " + e.getMessage());
        }
        if (debugEnabled) {
            log.debug("connection " + this.toDebugString() + " closed");
        }
    }

    @Override
    public boolean isClosed() {
        return this.pool.closed.get() || this.pool.getClient().isClosed() || this.closed.get();
    }

    @Override
    public JPPFConnectionPool getConnectionPool() {
        return this.pool;
    }

    public void submitInitialization() {
        if (this.initializing.compareAndSet(false, true)) {
            this.getClient().getExecutor().submit(new ConnectionInitializer(this));
        }
    }
}

