/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum JPPFClientConnectionStatus {
    NEW,
    DISCONNECTED,
    CONNECTING,
    ACTIVE,
    EXECUTING,
    FAILED,
    CLOSED;

    private static final List<JPPFClientConnectionStatus> WORKING_STATUSES;
    private static final List<JPPFClientConnectionStatus> TERMINATED_STATUSES;

    public boolean isOneOf(List<JPPFClientConnectionStatus> statuses) {
        if (statuses == null) {
            return false;
        }
        for (JPPFClientConnectionStatus status : statuses) {
            if (this != status) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkingStatus() {
        return this.isOneOf(WORKING_STATUSES);
    }

    public boolean isTerminatedStatus() {
        return this.isOneOf(TERMINATED_STATUSES);
    }

    public static JPPFClientConnectionStatus[] workingStatuses() {
        return WORKING_STATUSES.toArray(new JPPFClientConnectionStatus[WORKING_STATUSES.size()]);
    }

    public static JPPFClientConnectionStatus[] terminatedStatuses() {
        return TERMINATED_STATUSES.toArray(new JPPFClientConnectionStatus[TERMINATED_STATUSES.size()]);
    }

    static {
        WORKING_STATUSES = Collections.unmodifiableList(Arrays.asList(ACTIVE, EXECUTING));
        TERMINATED_STATUSES = Collections.unmodifiableList(Arrays.asList(CLOSED, FAILED));
    }
}

