/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Arrays;
import java.util.List;
import org.jppf.client.AbstractClientConnectionPool;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.recovery.HeartbeatConnection;
import org.jppf.comm.recovery.HeartbeatConnectionEvent;
import org.jppf.comm.recovery.HeartbeatConnectionListener;
import org.jppf.discovery.ClientConnectionPoolInfo;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Operator;
import org.jppf.utils.concurrent.ConcurrentUtils;
import org.jppf.utils.concurrent.MutableReference;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFConnectionPool
extends AbstractClientConnectionPool
implements HeartbeatConnectionListener {
    private static Logger log = LoggerFactory.getLogger(JPPFConnectionPool.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final boolean heartbeatEnabled;
    private HeartbeatConnection heartbeatConnection;

    JPPFConnectionPool(JPPFClient client, int id, String name, int priority, int size, boolean sslEnabled, int jmxPoolSize, boolean heartbeatEnabled, int maxJobs) {
        super(client, id, name, priority, size, sslEnabled, jmxPoolSize, maxJobs);
        this.heartbeatEnabled = heartbeatEnabled;
    }

    JPPFConnectionPool(JPPFClient client, int id, ClientConnectionPoolInfo info) {
        this(client, id, info.getName(), info.getPriority(), info.getPoolSize(), info.isSecure(), info.getJmxPoolSize(), info.isHeartbeatEnabled(), info.getMaxJobs());
        this.discoveryInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSize(int newSize) {
        int currentSize = this.getSize();
        if (currentSize == newSize) {
            return currentSize;
        }
        if (debugEnabled) {
            log.debug("requesting new size={}, current size={}", (Object)newSize, (Object)currentSize);
        }
        int diff = newSize - currentSize;
        int size = this.connectionCount();
        if (diff < 0) {
            int actual = 0;
            int i = size;
            while (--i >= 0 && actual < -diff) {
                JPPFClientConnection c = (JPPFClientConnection)this.getConnection(i);
                if (!this.connectionHasStatus(c, false, JPPFClientConnectionStatus.EXECUTING)) continue;
                if (debugEnabled) {
                    log.debug("removing connection {} from pool {}", (Object)c, (Object)this);
                }
                c.close();
                this.remove(c);
                ++actual;
            }
            JPPFConnectionPool jPPFConnectionPool = this;
            synchronized (jPPFConnectionPool) {
                this.size -= actual;
            }
        }
        JPPFConnectionPool actual = this;
        synchronized (actual) {
            this.size += diff;
        }
        for (int i = 0; i < diff; ++i) {
            this.client.submitNewConnection(this);
        }
        return this.getSize();
    }

    void initHeartbeat() {
        if (this.heartbeatEnabled && this.heartbeatConnection == null) {
            if (debugEnabled) {
                log.debug("Initializing recovery");
            }
            this.heartbeatConnection = new HeartbeatConnection(65526, this.client.getUuid(), this.getDriverHost(), this.getDriverPort(), this.sslEnabled);
            this.heartbeatConnection.addClientConnectionListener((HeartbeatConnectionListener)this);
            ThreadUtils.startThread((Runnable)this.heartbeatConnection, (String)(this.name + "-Heartbeat"));
        }
    }

    public void heartbeatConnectionFailed(HeartbeatConnectionEvent event) {
        this.close();
    }

    public List<JPPFClientConnection> awaitActiveConnections(ComparisonOperator operator, int nbConnections) {
        return this.awaitConnections(operator, nbConnections, Long.MAX_VALUE, JPPFClientConnectionStatus.ACTIVE);
    }

    public JPPFClientConnection awaitActiveConnection() {
        return this.awaitActiveConnections((ComparisonOperator)Operator.AT_LEAST, 1).get(0);
    }

    public List<JPPFClientConnection> awaitWorkingConnections(ComparisonOperator operator, int nbConnections) {
        return this.awaitConnections(operator, nbConnections, Long.MAX_VALUE, JPPFClientConnectionStatus.ACTIVE, JPPFClientConnectionStatus.EXECUTING);
    }

    public JPPFClientConnection awaitWorkingConnection() {
        return this.awaitWorkingConnections((ComparisonOperator)Operator.AT_LEAST, 1).get(0);
    }

    public List<JPPFClientConnection> awaitConnections(ComparisonOperator operator, int nbConnections, JPPFClientConnectionStatus ... statuses) {
        return this.awaitConnections(operator, nbConnections, Long.MAX_VALUE, statuses);
    }

    public JPPFClientConnection awaitConnection(JPPFClientConnectionStatus ... statuses) {
        return this.awaitConnections((ComparisonOperator)Operator.AT_LEAST, 1, Long.MAX_VALUE, statuses).get(0);
    }

    public List<JPPFClientConnection> awaitConnections(ComparisonOperator operator, int nbConnections, long timeout, JPPFClientConnectionStatus ... statuses) {
        Operator op;
        Object object = op = operator == null ? Operator.EQUAL : operator;
        if (debugEnabled) {
            log.debug("awaiting {} connections with operator={} and status in {}", new Object[]{nbConnections, op, Arrays.asList(statuses)});
        }
        MutableReference ref = new MutableReference();
        ConcurrentUtils.awaitCondition(() -> this.lambda$awaitConnections$0((ComparisonOperator)op, ref, statuses, nbConnections), (long)timeout, (long)10L, (boolean)false);
        if (debugEnabled) {
            log.debug("got expected connections: " + ref.get());
        }
        return (List)ref.get();
    }

    public List<JMXDriverConnectionWrapper> awaitJMXConnections(ComparisonOperator operator, int nbConnections, boolean connectedOnly) {
        return this.jmxPool.awaitJMXConnections(operator, nbConnections, Long.MAX_VALUE, connectedOnly);
    }

    public List<JMXDriverConnectionWrapper> awaitJMXConnections(ComparisonOperator operator, int nbConnections, long timeout, boolean connectedOnly) {
        return this.jmxPool.awaitJMXConnections(operator, nbConnections, timeout, connectedOnly);
    }

    public JMXDriverConnectionWrapper awaitJMXConnection(boolean connectedOnly) {
        return this.awaitJMXConnections((ComparisonOperator)Operator.AT_LEAST, 1, connectedOnly).get(0);
    }

    public JMXDriverConnectionWrapper awaitWorkingJMXConnection() {
        return this.awaitJMXConnections((ComparisonOperator)Operator.AT_LEAST, 1, true).get(0);
    }

    @Override
    public void close() {
        if (this.heartbeatConnection != null) {
            this.heartbeatConnection.close();
        }
        super.close();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + "name=" + this.name + ", id=" + this.id + ", size=" + this.size + ", priority=" + this.priority + ", driverHost=" + (this.hostIP != null ? this.hostIP.hostName() : null) + ", driverPort=" + this.driverPort + ", sslEnabled=" + this.sslEnabled + ", heartbeatEnabled=" + this.heartbeatEnabled + ", maxJobs=" + this.maxJobs + ']';
    }

    private /* synthetic */ boolean lambda$awaitConnections$0(ComparisonOperator op, MutableReference ref, JPPFClientConnectionStatus[] statuses, int nbConnections) {
        return op.evaluate((long)((List)ref.set(this.getConnections(statuses))).size(), (long)nbConnections);
    }
}

