/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.JPPFException;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.comm.interceptor.InterceptorHandler;
import org.jppf.comm.socket.SocketClient;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFIdentifiers;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServerConnectionHandler
extends AbstractClientConnectionHandler {
    private static Logger log = LoggerFactory.getLogger(TaskServerConnectionHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    TaskServerConnectionHandler(JPPFClientConnection owner, String host, int port) {
        super(owner, owner.getName() + " - TasksServer");
        this.host = host;
        this.port = port;
    }

    @Override
    public void init() throws Exception {
        boolean done = false;
        while (!done && !this.isClosed()) {
            if (this.socketClient == null) {
                this.initSocketClient();
            }
            boolean sysoutEnabled = this.owner.getConnectionPool().getClient().isSysoutEnabled();
            String msg = String.format("[client: %s] Attempting connection to the task server at %s:%d", this.name, this.host, this.port);
            if (sysoutEnabled) {
                System.out.println(msg);
            }
            log.info(msg);
            if (!this.socketInitializer.initialize(this.socketClient)) {
                throw new JPPFException(String.format("[%s] Could not reconnect to the JPPF task server", this.name));
            }
            if (!InterceptorHandler.invokeOnConnect((SocketWrapper)this.socketClient)) {
                throw new JPPFException(String.format("[%s] Could not reconnect to the JPPF task server due to interceptor failure", this.name));
            }
            try {
                if (debugEnabled) {
                    log.debug("sending JPPF identifier {}", (Object)JPPFIdentifiers.asString((int)65530));
                }
                this.socketClient.writeInt(65530);
                if (this.owner.isSSLEnabled()) {
                    this.createSSLConnection();
                }
                ((JPPFClientConnectionImpl)this.owner).sendHandshakeJob();
                this.owner.getConnectionPool().setJmxPort(this.owner.getConnectionPool().getDriverPort());
                msg = "[client: " + this.name + "] Reconnected to the JPPF task server";
                if (sysoutEnabled) {
                    System.out.println(msg);
                }
                log.info(msg);
                done = true;
            }
            catch (Exception e) {
                String format = "error initializing connection to job server: {}";
                if (debugEnabled) {
                    log.debug("error initializing connection to job server: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    continue;
                }
                log.warn("error initializing connection to job server: {}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    @Override
    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }
}

