/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.TaskServerConnectionHandler;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusHandler;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManager;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JPPFTaskBundle;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.utils.CryptoUtils;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelWrapperRemote
extends ChannelWrapper
implements ClientConnectionStatusHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractChannelWrapperRemote.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final JPPFClientConnection channel;
    protected String uuid;

    public AbstractChannelWrapperRemote(JPPFClientConnection channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.channel = channel;
        JPPFConnectionPool pool = channel.getConnectionPool();
        this.uuid = pool.getDriverUuid();
        this.priority = pool.getPriority();
        this.systemInfo = new JPPFSystemInformation(channel.getConnectionPool().getClient().getConfig(), this.uuid, false, true);
        this.managementInfo = new JPPFManagementInfo("remote", "remote", -1, this.getConnectionUuid(), 0, pool.isSslEnabled());
        this.managementInfo.setSystemInfo(this.systemInfo);
    }

    @Override
    public void setSystemInformation(JPPFSystemInformation systemInfo) {
        super.setSystemInformation(systemInfo);
    }

    @Override
    public void initChannelID() {
        JPPFBundlerFactory factory;
        if (this.channelID != null) {
            return;
        }
        if (this.systemInfo == null) {
            return;
        }
        if (this.uuid == null) {
            this.uuid = this.systemInfo.getUuid().getProperty("jppf.uuid");
            if (this.uuid != null && this.uuid.isEmpty()) {
                this.uuid = null;
            }
        }
        if ((factory = this.channel.getConnectionPool().getClient().getBundlerFactory()).getPersistence() == null) {
            this.channelID = new Pair((Object)"no_persistence", (Object)"no_persistence");
            return;
        }
        try {
            TaskServerConnectionHandler handler = ((JPPFClientConnectionImpl)this.channel).getTaskServerConnection();
            SocketWrapper socketClient = handler.getSocketClient();
            if (socketClient != null) {
                StringBuilder sb = new StringBuilder();
                String ip = this.channel.getConnectionPool().getDriverIPAddress();
                sb.append(this.channel.getName());
                sb.append('[').append(ip == null ? "localhost" : ip).append(']');
                InetSocketAddress sa = (InetSocketAddress)socketClient.getSocket().getRemoteSocketAddress();
                sb.append(sa.getAddress().getHostAddress()).append(':').append(socketClient.getPort());
                sb.append(this.channel.isSSLEnabled());
                String s = sb.toString();
                this.channelID = new Pair((Object)s, (Object)CryptoUtils.computeHash((String)s, (String)factory.getHashAlgorithm()));
                if (debugEnabled) {
                    log.debug("computed channelID for {} : {}", (Object)this, (Object)this.channelID);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getConnectionUuid() {
        return this.channel.getConnectionUuid();
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.channel.getStatus();
    }

    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        this.setOldStatus(this.getStatus());
        this.channel.setStatus(status);
    }

    public JPPFClientConnection getChannel() {
        return this.channel;
    }

    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.channel.addClientConnectionStatusListener(listener);
    }

    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.channel.removeClientConnectionStatusListener(listener);
    }

    public boolean isLocal() {
        return false;
    }

    void reconnect() {
        if (this.channel.isClosed()) {
            if (debugEnabled) {
                log.debug("connection is closed, will not reconnect");
            }
            return;
        }
        this.channel.setStatus(JPPFClientConnectionStatus.DISCONNECTED);
        ((JPPFClientConnectionImpl)this.channel).submitInitialization();
    }

    @Override
    public boolean cancel(ClientTaskBundle bundle) {
        if (bundle.isCancelled()) {
            return false;
        }
        String uuid = bundle.getClientJob().getUuid();
        if (debugEnabled) {
            log.debug("requesting cancel of jobId=" + uuid);
        }
        bundle.cancel();
        return true;
    }

    @Override
    LoadBalancerPersistenceManager getLoadBalancerPersistenceManager() {
        return (LoadBalancerPersistenceManager)this.channel.getConnectionPool().getClient().getLoadBalancerPersistenceManagement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[channel=");
        try {
            sb.append(this.channel);
        }
        catch (Exception e) {
            sb.append(ExceptionUtils.getMessage((Throwable)e));
        }
        sb.append(']');
        return sb.toString();
    }

    static TaskBundle createBundle(ClientTaskBundle clientBundle, long bundleId) {
        JPPFTaskBundle bundle = new JPPFTaskBundle();
        bundle.setUuid(clientBundle.getUuid());
        bundle.setParameter((Object)BundleParameter.CLIENT_BUNDLE_ID, (Object)bundleId);
        ClientJob job = clientBundle.getClientJob();
        if (job.getTaskGraph() != null && !job.getClientSLA().isGraphTraversalInClient()) {
            bundle.setParameter((Object)BundleParameter.JOB_TASK_GRAPH, (Object)job.getTaskGraph());
        }
        return bundle;
    }

    Collection<ClassLoader> registerClassLoaders(String jobUuid, List<Task<?>> tasks) {
        if (jobUuid == null) {
            throw new IllegalArgumentException("jobUuid is null");
        }
        HashSet<ClassLoader> result = new HashSet<ClassLoader>();
        if (!tasks.isEmpty()) {
            JPPFClient client = this.channel.getConnectionPool().getClient();
            for (Task<?> task : tasks) {
                Object o;
                ClassLoader cl;
                if (task == null || (cl = (o = task.getTaskObject()) != null ? o.getClass().getClassLoader() : task.getClass().getClassLoader()) == null || result.contains(cl)) continue;
                client.registerClassLoader(cl, jobUuid);
                result.add(cl);
            }
        }
        return result;
    }
}

