/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorChannelStatusEvent;
import org.jppf.execute.ExecutorChannelStatusListener;
import org.jppf.execute.ExecutorStatus;
import org.jppf.load.balancer.Bundler;
import org.jppf.load.balancer.ChannelAwareness;
import org.jppf.load.balancer.ContextAwareness;
import org.jppf.load.balancer.JPPFContext;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManager;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelWrapper
implements ExecutorChannel<ClientTaskBundle> {
    private static Logger log = LoggerFactory.getLogger(ChannelWrapper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    Bundler<?> bundler;
    JPPFSystemInformation systemInfo;
    JPPFManagementInfo managementInfo;
    final List<ExecutorChannelStatusListener> listenerList = new CopyOnWriteArrayList<ExecutorChannelStatusListener>();
    int priority;
    boolean resetting;
    Pair<String, String> channelID;
    String bundlerAlgorithm;
    final AtomicInteger jobCount = new AtomicInteger(0);
    protected JPPFClientConnectionStatus oldStatus = JPPFClientConnectionStatus.NEW;

    protected ChannelWrapper() {
    }

    public abstract JPPFClientConnectionStatus getStatus();

    public ExecutorStatus getExecutionStatus() {
        switch (this.getStatus()) {
            case ACTIVE: {
                return ExecutorStatus.ACTIVE;
            }
            case CLOSED: 
            case FAILED: {
                return ExecutorStatus.FAILED;
            }
            case EXECUTING: {
                return ExecutorStatus.EXECUTING;
            }
        }
        return ExecutorStatus.DISABLED;
    }

    public abstract void addClientConnectionStatusListener(ClientConnectionStatusListener var1);

    public abstract void removeClientConnectionStatusListener(ClientConnectionStatusListener var1);

    public Bundler<?> getBundler() {
        return this.bundler;
    }

    public Bundler<?> checkBundler(JPPFBundlerFactory factory, JPPFContext jppfContext) {
        if (factory == null) {
            throw new IllegalArgumentException("Bundler factory is null");
        }
        if (this.bundler == null || this.bundler.getTimestamp() < factory.getLastUpdateTime()) {
            if (this.bundler != null) {
                this.bundler.dispose();
                if (this.bundler instanceof ContextAwareness) {
                    ((ContextAwareness)this.bundler).setJPPFContext(null);
                }
            }
            Pair bp = this.getLoadBalancerPersistenceManager().loadBundler(this.channelID);
            this.bundler = (Bundler)bp.second();
            this.bundlerAlgorithm = (String)bp.first();
            if (this.bundler instanceof ContextAwareness) {
                ((ContextAwareness)this.bundler).setJPPFContext(jppfContext);
            }
            this.bundler.setup();
            if (this.bundler instanceof ChannelAwareness) {
                ((ChannelAwareness)this.bundler).setChannelConfiguration(this.systemInfo);
            }
        }
        return this.bundler;
    }

    abstract LoadBalancerPersistenceManager getLoadBalancerPersistenceManager();

    public JPPFSystemInformation getSystemInformation() {
        if (traceEnabled) {
            log.trace("getting system info for " + this + ", jppf.channel.local=" + this.systemInfo.getJppf().getProperty("jppf.channel.local") + ", isLocal()=" + this.isLocal());
        }
        return this.systemInfo;
    }

    public void setSystemInformation(JPPFSystemInformation systemInfo) {
        if (systemInfo != null) {
            systemInfo.getJppf().setBoolean("jppf.channel.local", this.isLocal());
            this.systemInfo = systemInfo;
            if (traceEnabled) {
                log.trace("setting system info for " + this + ", jppf.channel.local=" + this.systemInfo.getJppf().getProperty("jppf.channel.local") + ", isLocal()=" + this.isLocal());
            }
        } else if (traceEnabled) {
            Exception e = new Exception("call stack for setSystemInfo(null)");
            log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public JPPFManagementInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(JPPFManagementInfo managementInfo) {
        if (managementInfo != null) {
            this.managementInfo = managementInfo;
        }
    }

    public void close() {
        if (this.bundler != null) {
            this.bundler.dispose();
        }
    }

    public Object getMonitor() {
        return this;
    }

    public void addExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listenerList.add(listener);
    }

    public void removeExecutionStatusListener(ExecutorChannelStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listenerList.remove(listener);
    }

    protected void fireExecutionStatusChanged(ExecutorStatus oldValue, ExecutorStatus newValue) {
        if (oldValue == newValue) {
            return;
        }
        ExecutorChannelStatusEvent event = new ExecutorChannelStatusEvent((Object)this, oldValue, newValue);
        for (ExecutorChannelStatusListener listener : this.listenerList) {
            listener.executionStatusChanged(event);
        }
    }

    public boolean isActive() {
        return true;
    }

    public int getPriority() {
        return this.priority;
    }

    public abstract boolean cancel(ClientTaskBundle var1);

    public boolean isResetting() {
        return this.resetting;
    }

    public void setResetting(boolean resetting) {
        this.resetting = resetting;
    }

    public void initChannelID() {
    }

    public int getCurrentNbJobs() {
        return this.jobCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFClientConnectionStatus getOldStatus() {
        Object object = this.getMonitor();
        synchronized (object) {
            return this.oldStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOldStatus(JPPFClientConnectionStatus oldStatus) {
        Object object = this.getMonitor();
        synchronized (object) {
            this.oldStatus = oldStatus;
        }
    }
}

