/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.List;
import org.jppf.execute.AbstractExecutionManager;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExecutionManager
extends AbstractExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(ClientExecutionManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    public ClientExecutionManager(TypedProperties config, JPPFProperty<Integer> nbThreadsProperty) {
        super(config, nbThreadsProperty);
    }

    protected void setup(TaskBundle bundle, List<Task<?>> taskList) {
        this.bundle = bundle;
        this.taskList = taskList;
        this.taskWrapperList = new ArrayList(taskList.size());
        this.dataProvider = taskList.get(0).getDataProvider();
        this.uuidList = bundle.getUuidPath().getList();
        ClassLoader taskClassLoader = null;
        try {
            taskClassLoader = ClientExecutionManager.getTaskClassLoader(taskList.get(0));
            this.usedClassLoader = this.threadManager.useClassLoader(taskClassLoader);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + " - class loader lookup failed for uuidPath=" + this.uuidList;
            if (debugEnabled) {
                log.debug(msg, (Throwable)e);
            }
            log.warn(msg);
        }
        this.accumulatedElapsed.set(0L);
    }

    protected void cleanup() {
        this.bundle.setParameter((Object)BundleParameter.NODE_BUNDLE_ELAPSED_PARAM, (Object)this.accumulatedElapsed.get());
        this.dataProvider = null;
        this.usedClassLoader.dispose();
        this.usedClassLoader = null;
        this.taskList = null;
        this.uuidList = null;
        this.setJobCancelled(false);
        this.taskWrapperList = null;
        this.timeoutHandler.clear();
    }

    private static ClassLoader getTaskClassLoader(Task<?> task) {
        return task.getTaskClassLoader();
    }
}

