/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jppf.JPPFException;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobStatus;
import org.jppf.client.balancer.AbstractChannelWrapperRemote;
import org.jppf.client.balancer.AbstractClientJob;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJobStatus;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.TaskStateMap;
import org.jppf.client.event.JobEvent;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.node.protocol.JPPFExceptionResult;
import org.jppf.node.protocol.JPPFExceptionResultEx;
import org.jppf.node.protocol.JPPFTaskSerializationException;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskState;
import org.jppf.node.protocol.graph.TaskGraph;
import org.jppf.node.protocol.graph.TaskGraphHelper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientJob
extends AbstractClientJob {
    private static final Logger log = LoggerFactory.getLogger(ClientJob.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final Map<Integer, Task<?>> tasks;
    private transient String broadcastUUID;
    private final Map<ClientTaskBundle, ChannelWrapper> bundleMap = new LinkedHashMap<ClientTaskBundle, ChannelWrapper>();
    private JobStatus jobStatus;
    private final Map<String, ClientJob> broadcastMap;
    private final Set<ClientJob> broadcastSet = new LinkedHashSet<ClientJob>();
    private Runnable onRequeue;
    private final TaskStateMap taskStateMap = new TaskStateMap();
    protected final int initialTaskCount;
    private final TaskGraph taskGraph;
    private final Set<Integer> dispatchedTasks = new HashSet<Integer>();

    public ClientJob(JPPFJob job, Collection<Task<?>> tasks) {
        this(job, tasks, null, null);
    }

    protected ClientJob(JPPFJob job, Collection<Task<?>> tasks, ClientJob parentJob, String broadcastUUID) {
        super(job);
        if (tasks == null) {
            throw new IllegalArgumentException("tasks is null");
        }
        this.parentJob = parentJob;
        this.broadcastUUID = broadcastUUID;
        this.initialTaskCount = tasks.size();
        this.broadcastMap = broadcastUUID == null && job.getSLA().isBroadcastJob() ? new LinkedHashMap<String, ClientJob>() : Collections.emptyMap();
        JobStatus s = job.getStatus();
        this.jobStatus = s == null ? JobStatus.SUBMITTED : s;
        this.tasks = new TreeMap();
        for (Task<?> task : tasks) {
            this.tasks.put(task.getPosition(), task);
        }
        for (Task<?> result : job.getResults().getAllResults()) {
            if (result == null) continue;
            this.taskStateMap.put(result.getPosition(), TaskState.RESULT);
        }
        TaskGraph taskGraph = this.taskGraph = job.hasTaskGraph() ? TaskGraphHelper.graphOf(tasks) : null;
        if (debugEnabled && this.taskGraph != null) {
            log.debug("taskGraph = {}", (Object)this.taskGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskCount() {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            return this.tasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientJob createBroadcastJob(String broadcastUUID) {
        ClientJob clientJob;
        if (broadcastUUID == null || broadcastUUID.isEmpty()) {
            throw new IllegalArgumentException("broadcastUUID is blank");
        }
        Map<Object, Object> map = this.tasks;
        synchronized (map) {
            clientJob = new ClientJob(this.job, this.tasks.values(), this, broadcastUUID);
        }
        map = this.bundleMap;
        synchronized (map) {
            this.broadcastSet.add(clientJob);
        }
        return clientJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ClientTaskBundle copy(int nbTasks) {
        ArrayList<Object> list = null;
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            if (this.taskGraph == null || !this.getJob().getClientSLA().isGraphTraversalInClient()) {
                if (nbTasks >= this.tasks.size() || this.taskGraph != null) {
                    list = new ArrayList(this.tasks.values());
                } else {
                    void var5_6;
                    list = new ArrayList(nbTasks);
                    Iterator<Map.Entry<Integer, Object>> it = this.tasks.entrySet().iterator();
                    boolean bl = false;
                    while (var5_6 < nbTasks) {
                        Map.Entry<Integer, Object> entry = it.next();
                        list.add(entry.getValue());
                        ++var5_6;
                    }
                }
                if (this.taskGraph != null) {
                    for (Task task : list) {
                        this.dispatchedTasks.add(task.getPosition());
                    }
                }
            } else {
                Set availablePos = this.taskGraph.getAvailableNodes();
                int n = Math.min(nbTasks, availablePos.size());
                Iterator iterator = availablePos.iterator();
                list = new ArrayList(n);
                for (int i = 0; i < n; ++i) {
                    int pos = (Integer)iterator.next();
                    if (this.dispatchedTasks.contains(pos)) continue;
                    this.dispatchedTasks.add(pos);
                    list.add(this.tasks.get(pos));
                }
                if (debugEnabled) {
                    log.debug("taskGraph = {}, sentTasks = {}", (Object)this.taskGraph, this.dispatchedTasks);
                }
            }
            ClientTaskBundle bundle = new ClientTaskBundle(this, list);
            for (Task task : list) {
                this.tasks.remove(task.getPosition());
            }
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean merge(List<Task<?>> taskList) {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            boolean requeue = this.tasks.isEmpty() && !taskList.isEmpty();
            for (Task<?> task : taskList) {
                this.tasks.put(task.getPosition(), task);
            }
            return requeue;
        }
    }

    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDispatched(ClientTaskBundle bundle, ChannelWrapper channel) {
        boolean empty;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        Map<ClientTaskBundle, ChannelWrapper> map = this.bundleMap;
        synchronized (map) {
            empty = this.bundleMap.isEmpty();
            if (debugEnabled) {
                log.debug("adding channel {} to bundleMap of {}", (Object)channel, (Object)this);
            }
            this.bundleMap.put(bundle, channel);
        }
        if (empty) {
            this.updateStatus(ClientJobStatus.NEW, ClientJobStatus.EXECUTING);
            this.setJobStatus(JobStatus.EXECUTING);
        }
        if (!this.isParentBroadcastJob()) {
            this.job.fireJobEvent(JobEvent.Type.JOB_DISPATCH, channel, bundle.getTasksL());
        }
        if (this.parentJob != null) {
            this.parentJob.broadcastDispatched(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobRequeued() {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            this.dispatchedTasks.clear();
        }
        this.updateStatus(ClientJobStatus.EXECUTING, ClientJobStatus.NEW);
        if (debugEnabled) {
            log.debug("job requeued: {}", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ClientTaskBundle bundle, List<Task<?>> results) {
        if (debugEnabled) {
            log.debug("received {} results for bundle {}", (Object)results.size(), (Object)bundle);
        }
        if (results.isEmpty()) {
            return;
        }
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            for (int i = 0; i < results.size(); ++i) {
                Task<?> task = results.get(i);
                int position = task.getPosition();
                this.taskStateMap.put(position, TaskState.RESULT);
                if (this.taskGraph != null) {
                    this.dispatchedTasks.remove(position);
                    this.taskGraph.nodeDone(position);
                }
                if (!(task instanceof JPPFExceptionResult)) continue;
                Throwable t = null;
                Task<?> originalTask = this.job.getJobTasks().get(position);
                if (task instanceof JPPFExceptionResultEx) {
                    JPPFExceptionResultEx result = (JPPFExceptionResultEx)task;
                    String message = String.format("[%s: %s]", result.getThrowableClassName(), result.getThrowableMessage());
                    t = new JPPFTaskSerializationException(message, result.getThrowableStackTrace());
                } else {
                    t = task.getThrowable();
                }
                originalTask.setThrowable(t);
                results.set(i, originalTask);
            }
            if (debugEnabled && this.taskGraph != null) {
                log.debug("taskGraph = {}, sentTasks = {}", (Object)this.taskGraph, this.dispatchedTasks);
            }
        }
        this.callResultListener(results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ClientTaskBundle bundle, Throwable throwable) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (debugEnabled) {
            log.debug("received  throwable {} for bundle ", (Object)throwable, (Object)bundle);
        }
        boolean ioe = throwable instanceof IOException && !(throwable instanceof NotSerializableException);
        Exception e = throwable instanceof Exception ? (Exception)throwable : new JPPFException(throwable);
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            for (Task<?> task : bundle.getTasksL()) {
                int position = task.getPosition();
                if (this.taskGraph != null) {
                    this.dispatchedTasks.remove(position);
                    this.taskGraph.nodeDone(position);
                }
                TaskState oldState = (TaskState)this.taskStateMap.get(position);
                if (ioe || oldState == TaskState.RESULT) continue;
                this.taskStateMap.put(task.getPosition(), TaskState.EXCEPTION);
                task.setThrowable((Throwable)e);
            }
            if (debugEnabled && this.taskGraph != null) {
                log.debug("taskGraph = {}, sentTasks = {}", (Object)this.taskGraph, this.dispatchedTasks);
            }
        }
        this.callResultListener(bundle.getTasksL(), throwable);
    }

    private void callResultListener(List<Task<?>> results, Throwable throwable) {
        if (this.job != null) {
            try {
                this.job.resultsReceived(results, throwable, !this.isParentBroadcastJob());
            }
            catch (Exception e) {
                log.error("error while calling the TaskResultListener for job [name={}, uuid={}] : {}", new Object[]{this.job.getName(), this.job.getUuid(), ExceptionUtils.getStackTrace((Throwable)e)});
            }
        } else if (this.isChildBroadcastJob()) {
            this.job.fireJobEvent(JobEvent.Type.JOB_RETURN, null, results);
        } else {
            log.warn("<null> result collector for job {}", (Object)this.job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(ClientTaskBundle bundle, Exception exception) {
        ArrayList list;
        if (debugEnabled) {
            log.debug("bundle={}, exception={} for {}", new Object[]{bundle, exception, this});
        }
        Map<ClientTaskBundle, ChannelWrapper> map = this.bundleMap;
        synchronized (map) {
            ChannelWrapper channel = this.bundleMap.remove((Object)bundle);
            if (debugEnabled) {
                log.debug("removed channel {} from bundleMap of {}", (Object)channel, (Object)this);
            }
        }
        boolean requeue = false;
        if (this.getSLA().isBroadcastJob()) {
            if (debugEnabled) {
                log.debug("processing broadcast job {}", (Object)this);
            }
            list = new ArrayList();
            Map<Integer, Task<?>> map2 = this.tasks;
            synchronized (map2) {
                if (bundle != null) {
                    for (Task<?> task : bundle.getTasksL()) {
                        if (this.taskStateMap.put(task.getPosition(), TaskState.RESULT) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                }
                if (this.isCancelled() || this.getBroadcastUUID() == null) {
                    list.addAll(this.tasks.values());
                    this.tasks.clear();
                }
            }
            this.resultsReceived(bundle, list);
        } else if (bundle == null) {
            if (debugEnabled) {
                log.debug("processing null bundle for job {}", (Object)this);
            }
            if (this.isCancelled()) {
                list = new ArrayList();
                Map<Integer, Task<?>> map3 = this.tasks;
                synchronized (map3) {
                    list.addAll(this.tasks.values());
                    this.tasks.clear();
                }
                this.resultsReceived(bundle, list);
            }
        } else {
            Map<Integer, Task<?>> map4;
            if (bundle.isCancelled()) {
                if (debugEnabled) {
                    log.debug("processing cancelled job {}", (Object)this);
                }
                list = new ArrayList();
                map4 = this.tasks;
                synchronized (map4) {
                    for (Task<?> task : bundle.getTasksL()) {
                        if (this.taskStateMap.get(task.getPosition()) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                    list.addAll(this.tasks.values());
                    this.tasks.clear();
                }
                this.resultsReceived(bundle, list);
            }
            if (bundle.isRequeued()) {
                if (debugEnabled) {
                    log.debug("processing requeued job {}", (Object)this);
                }
                list = new ArrayList();
                map4 = this.tasks;
                synchronized (map4) {
                    for (Task<?> task : bundle.getTasksL()) {
                        if (this.taskStateMap.get(task.getPosition()) == TaskState.RESULT) continue;
                        list.add(task);
                    }
                    requeue = this.merge(list);
                    if (debugEnabled) {
                        log.debug("requeue = {}, resubmit list = {}", (Object)requeue, (Object)list.size());
                    }
                }
            }
        }
        if (this.hasPending()) {
            if (debugEnabled) {
                log.debug("processing hasPending for {}", (Object)this);
            }
            if (exception != null) {
                this.setJobStatus(exception instanceof NotSerializableException ? JobStatus.COMPLETE : JobStatus.FAILED);
            }
            if (requeue && this.onRequeue != null) {
                this.onRequeue.run();
                this.updateStatus(ClientJobStatus.NEW, ClientJobStatus.EXECUTING);
            }
        } else {
            if (debugEnabled) {
                log.debug("processing cancelled or done for job {}", (Object)this);
            }
            boolean callDone = this.updateStatus(this.isCancelled() ? ClientJobStatus.CANCELLED : ClientJobStatus.EXECUTING, ClientJobStatus.DONE);
            try {
                if (callDone) {
                    this.done();
                }
            }
            finally {
                if (this.parentJob != null) {
                    this.parentJob.broadcastCompleted(this);
                }
            }
            this.setJobStatus(JobStatus.COMPLETE);
        }
        if (debugEnabled) {
            log.debug("finished taskCOmpleted() for {}", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPending() {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            if (this.tasks.isEmpty() && this.taskStateMap.size() >= this.job.getJobTasks().size()) {
                return this.taskStateMap.getStateCount(TaskState.EXCEPTION) > 0;
            }
            return true;
        }
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        if (this.jobStatus == jobStatus) {
            return;
        }
        this.jobStatus = jobStatus;
        if (this.job != null) {
            this.job.setStatus(this.jobStatus);
        } else if ((jobStatus == JobStatus.COMPLETE || jobStatus == JobStatus.FAILED) && this.isChildBroadcastJob()) {
            this.job.fireJobEvent(JobEvent.Type.JOB_END, null, new ArrayList(this.tasks.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (debugEnabled) {
            log.debug("requesting cancel of jobId=" + this.getUuid());
        }
        if (super.cancel(mayInterruptIfRunning)) {
            boolean bl;
            ArrayList<ClientJob> list;
            this.job.getCancelledFlag().set(true);
            HashMap<ClientTaskBundle, ChannelWrapper> map = null;
            Map<ClientTaskBundle, ChannelWrapper> map2 = this.bundleMap;
            synchronized (map2) {
                list = new ArrayList<ClientJob>(this.broadcastSet.size() + this.broadcastMap.size());
                list.addAll(this.broadcastMap.values());
                list.addAll(this.broadcastSet);
                map = new HashMap<ClientTaskBundle, ChannelWrapper>(this.bundleMap);
            }
            for (ClientJob clientJob : list) {
                clientJob.cancel(mayInterruptIfRunning);
            }
            HashSet<String> uuids = new HashSet<String>();
            for (Map.Entry entry : map.entrySet()) {
                try {
                    JPPFConnectionPool pool;
                    String driverUuid;
                    ChannelWrapper wrapper = (ChannelWrapper)entry.getValue();
                    wrapper.cancel((ClientTaskBundle)((Object)entry.getKey()));
                    if (wrapper.isLocal() || uuids.contains(driverUuid = (pool = ((AbstractChannelWrapperRemote)wrapper).getChannel().getConnectionPool()).getDriverUuid())) continue;
                    uuids.add(driverUuid);
                    try {
                        JMXDriverConnectionWrapper jmx;
                        if (debugEnabled) {
                            log.debug("sending cancel request for jobId={} to driver={}", (Object)this.getUuid(), (Object)driverUuid);
                        }
                        if ((jmx = pool.getJmxConnection()) == null) continue;
                        jmx.cancelJob(this.getUuid());
                    }
                    catch (Exception e) {
                        if (debugEnabled) {
                            log.debug(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        log.warn(ExceptionUtils.getMessage((Throwable)e));
                    }
                }
                catch (Exception e) {
                    log.error("Error cancelling job " + this, (Throwable)e);
                }
            }
            Map<ClientTaskBundle, ChannelWrapper> map3 = this.bundleMap;
            synchronized (map3) {
                this.broadcastSet.clear();
                bl = this.bundleMap.isEmpty() && this.broadcastMap.isEmpty();
            }
            if (bl) {
                this.taskCompleted(null, null);
            }
            if (debugEnabled) {
                log.debug("setting cancelled flag on job {}", (Object)this.job);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastDispatched(ClientJob broadcastJob) {
        boolean empty;
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        Map<ClientTaskBundle, ChannelWrapper> map = this.bundleMap;
        synchronized (map) {
            this.broadcastSet.remove(broadcastJob);
            empty = this.broadcastMap.isEmpty();
            this.broadcastMap.put(broadcastJob.getBroadcastUUID(), broadcastJob);
        }
        if (empty) {
            this.updateStatus(ClientJobStatus.NEW, ClientJobStatus.EXECUTING);
            this.setJobStatus(JobStatus.EXECUTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastCompleted(ClientJob broadcastJob) {
        boolean empty;
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        Map<ClientTaskBundle, ChannelWrapper> map = this.bundleMap;
        synchronized (map) {
            if (this.broadcastMap.remove(broadcastJob.getBroadcastUUID()) != broadcastJob && !this.broadcastSet.contains(broadcastJob) && debugEnabled) {
                log.debug("broadcast job not found: " + broadcastJob);
            }
            empty = this.broadcastMap.isEmpty();
        }
        if (empty) {
            this.taskCompleted(null, null);
        }
    }

    public void setOnRequeue(Runnable onRequeue) {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.onRequeue = onRequeue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbChannels() {
        Map<ClientTaskBundle, ChannelWrapper> map = this.bundleMap;
        synchronized (map) {
            return this.bundleMap.size();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "uuid=" + this.job.getUuid() + ", jobName=" + this.job.getName() + ", jobStatus=" + (Object)((Object)this.jobStatus) + ", broadcastUUID=" + this.broadcastUUID + ", nbTasks=" + this.tasks.size() + ", taskGraph=" + this.taskGraph + ']';
    }

    public TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAvvailableGraphNode() {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            if (this.taskGraph == null) {
                return false;
            }
            return this.taskGraph.getAvailableNodes().size() - this.dispatchedTasks.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableGraphNodeCount() {
        Map<Integer, Task<?>> map = this.tasks;
        synchronized (map) {
            return this.taskGraph != null ? this.taskGraph.getAvailableNodes().size() - this.dispatchedTasks.size() : -1;
        }
    }
}

