/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobManager;
import org.jppf.client.balancer.AbstractChannelWrapperRemote;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ChannelWrapperLocal;
import org.jppf.client.balancer.ChannelWrapperRemoteAsync;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.client.balancer.queue.JobScheduler;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ConnectionPoolEvent;
import org.jppf.client.event.ConnectionPoolListenerAdapter;
import org.jppf.client.event.JobStatusListener;
import org.jppf.load.balancer.LoadBalancingInformation;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.protocol.Task;
import org.jppf.queue.QueueEvent;
import org.jppf.queue.QueueListener;
import org.jppf.queue.QueueListenerAdapter;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.collections.CollectionSortedMap;
import org.jppf.utils.collections.DescendingIntegerComparator;
import org.jppf.utils.collections.LinkedListSortedMap;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerClient
extends ThreadSynchronization
implements JobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManagerClient.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFPriorityQueue queue;
    private final JPPFBundlerFactory bundlerFactory;
    private LoadBalancingInformation currentLoadBalancingInformation;
    private final Object loadBalancingInformationLock = new Object();
    private final JobScheduler jobScheduler;
    private final Map<JPPFClientConnection, ChannelWrapper> wrapperMap = new HashMap<JPPFClientConnection, ChannelWrapper>();
    private final CollectionSortedMap<Integer, ChannelWrapper> allConnections = new LinkedListSortedMap((Comparator)new DescendingIntegerComparator());
    private final ClientConnectionStatusListener statusListener = event -> {
        if (event.getSource() instanceof ChannelWrapperLocal) {
            this.updateConnectionStatus((ChannelWrapper)event.getSource(), event.getOldStatus());
        } else if (event.getSource() instanceof JPPFClientConnection) {
            this.updateConnectionStatus((JPPFClientConnection)event.getSource(), event.getOldStatus());
        }
    };
    private boolean localEnabled;
    private ChannelWrapperLocal wrapperLocal;
    private final CollectionSortedMap<Integer, ChannelWrapper> workingConnections = new LinkedListSortedMap((Comparator)new DescendingIntegerComparator());
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JPPFClient client;

    public JobManagerClient(JPPFClient client, JPPFBundlerFactory bundlerFactory) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.client = client;
        this.localEnabled = (Boolean)client.getConfig().get(JPPFProperties.LOCAL_EXECUTION_ENABLED);
        this.queue = new JPPFPriorityQueue(this);
        this.bundlerFactory = bundlerFactory;
        this.currentLoadBalancingInformation = bundlerFactory.getCurrentInfo();
        this.jobScheduler = new JobScheduler(this.queue, bundlerFactory);
        this.queue.addQueueListener((QueueListener)new QueueListenerAdapter<ClientJob, ClientJob, ClientTaskBundle>(){

            public void bundleAdded(QueueEvent<ClientJob, ClientJob, ClientTaskBundle> event) {
                JobManagerClient.this.jobScheduler.wakeUp();
            }
        });
        ThreadUtils.startDaemonThread((Runnable)this.jobScheduler, (String)"JobScheduler");
        this.queue.addQueueListener(client);
        client.addConnectionPoolListener(new ConnectionPoolListenerAdapter(){

            @Override
            public void connectionRemoved(ConnectionPoolEvent event) {
                JobManagerClient.this.removeConnection(event.getConnection());
            }
        });
        this.updateLocalExecution(this.localEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(ChannelWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper is null");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("this job manager was closed");
        }
        if (log.isDebugEnabled()) {
            log.debug("adding connection " + wrapper);
        }
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.allConnections;
        synchronized (collectionSortedMap) {
            this.allConnections.putValue((Object)wrapper.getPriority(), (Object)wrapper);
        }
        this.updateConnectionStatus(wrapper, JPPFClientConnectionStatus.NEW, wrapper.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(ChannelWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper is null");
        }
        try {
            JPPFClientConnectionStatus status = wrapper.getStatus();
            if (!status.isTerminatedStatus()) {
                this.updateConnectionStatus(wrapper, wrapper.getStatus(), JPPFClientConnectionStatus.DISCONNECTED);
            } else {
                this.updateConnectionStatus(wrapper, wrapper.getOldStatus(), wrapper.getStatus());
            }
        }
        finally {
            CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.allConnections;
            synchronized (collectionSortedMap) {
                this.allConnections.removeValue((Object)wrapper.getPriority(), (Object)wrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelWrapper addConnection(JPPFClientConnection cnn) {
        if (debugEnabled) {
            log.debug("adding connection " + cnn);
        }
        if (this.closed.get()) {
            throw new IllegalStateException("this job manager was closed");
        }
        ChannelWrapper wrapper = null;
        Map<JPPFClientConnection, ChannelWrapper> map = this.wrapperMap;
        synchronized (map) {
            wrapper = this.wrapperMap.get(cnn);
        }
        if (wrapper == null) {
            Object systemInfo;
            try {
                wrapper = new ChannelWrapperRemoteAsync(cnn);
                systemInfo = cnn.getSystemInfo();
                if (systemInfo != null) {
                    wrapper.setSystemInformation((JPPFSystemInformation)systemInfo);
                }
                JPPFConnectionPool pool = cnn.getConnectionPool();
                JPPFManagementInfo info = new JPPFManagementInfo(pool.getDriverHost(), pool.getDriverIPAddress(), pool.getJmxPort(), pool.getDriverUuid(), 0, pool.isSslEnabled());
                if (systemInfo != null) {
                    info.setSystemInfo(systemInfo);
                }
                wrapper.setManagementInfo(info);
            }
            catch (Throwable e) {
                log.error("Error while adding connection " + cnn, e);
            }
            finally {
                systemInfo = this.wrapperMap;
                synchronized (systemInfo) {
                    this.wrapperMap.put(cnn, wrapper);
                }
                this.addConnection(wrapper);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("end of adding connection " + cnn);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelWrapper removeConnection(JPPFClientConnection connection) {
        ChannelWrapper wrapper = null;
        Map<JPPFClientConnection, ChannelWrapper> map = this.wrapperMap;
        synchronized (map) {
            wrapper = this.wrapperMap.remove(connection);
        }
        if (wrapper != null) {
            if (debugEnabled) {
                log.debug("removing connection {}", (Object)connection);
            }
            this.removeConnection(wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelWrapper> getAllConnections() {
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.allConnections;
        synchronized (collectionSortedMap) {
            return new ArrayList<ChannelWrapper>(this.allConnections.allValues());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelWrapper> getWorkingConnections() {
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.workingConnections;
        synchronized (collectionSortedMap) {
            return new ArrayList<ChannelWrapper>(this.workingConnections.allValues());
        }
    }

    public List<ChannelWrapper> getWorkingRemoteConnections() {
        List<ChannelWrapper> result = this.getWorkingConnections();
        if (this.isLocalExecutionEnabled()) {
            Iterator<ChannelWrapper> it = result.iterator();
            while (it.hasNext()) {
                ChannelWrapper channel = it.next();
                if (!channel.isLocal()) continue;
                it.remove();
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWorkingConnection() {
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.workingConnections;
        synchronized (collectionSortedMap) {
            return !this.workingConnections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectionStatus(JPPFClientConnection connection, JPPFClientConnectionStatus oldStatus) {
        ChannelWrapper wrapper = null;
        Map<JPPFClientConnection, ChannelWrapper> map = this.wrapperMap;
        synchronized (map) {
            wrapper = this.wrapperMap.get(connection);
        }
        if (wrapper != null) {
            if (oldStatus == JPPFClientConnectionStatus.CONNECTING && wrapper.getStatus() == JPPFClientConnectionStatus.ACTIVE) {
                JPPFSystemInformation systemInfo = connection.getSystemInfo();
                JMXDriverConnectionWrapper jmx = connection.getConnectionPool().getJmxConnection();
                wrapper.setSystemInformation(systemInfo);
                if (!wrapper.isLocal()) {
                    String driverUuid = connection.getDriverUuid();
                    JPPFManagementInfo info = null;
                    JPPFConnectionPool pool = connection.getConnectionPool();
                    info = jmx != null ? new JPPFManagementInfo(pool.getDriverHost(), pool.getDriverIPAddress(), jmx.getPort(), jmx.getId(), 0, connection.isSSLEnabled()) : new JPPFManagementInfo(pool.getDriverHost(), pool.getDriverIPAddress(), -1, driverUuid != null ? driverUuid : "?", 0, connection.isSSLEnabled());
                    info.setSystemInfo(systemInfo);
                    wrapper.setManagementInfo(info);
                }
            }
            this.updateConnectionStatus(wrapper, oldStatus);
        }
    }

    private void updateConnectionStatus(ChannelWrapper wrapper, JPPFClientConnectionStatus oldStatus) {
        if (wrapper == null) {
            return;
        }
        this.updateConnectionStatus(wrapper, oldStatus, wrapper.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectionStatus(ChannelWrapper wrapper, JPPFClientConnectionStatus oldStatus, JPPFClientConnectionStatus newStatus) {
        if (this.closed.get()) {
            return;
        }
        if (oldStatus == null) {
            throw new IllegalArgumentException("oldStatus is null");
        }
        if (newStatus == null) {
            throw new IllegalArgumentException("newStatus is null");
        }
        if (debugEnabled) {
            log.debug("updating status from {} to {} for {}", new Object[]{oldStatus, newStatus, wrapper});
        }
        if (wrapper == null || oldStatus == newStatus) {
            return;
        }
        boolean bNew = newStatus.isWorkingStatus();
        boolean bOld = oldStatus.isWorkingStatus();
        if (bNew && !bOld) {
            CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.workingConnections;
            synchronized (collectionSortedMap) {
                this.workingConnections.putValue((Object)wrapper.getPriority(), (Object)wrapper);
                this.jobScheduler.setHighestPriority((Integer)this.workingConnections.firstKey());
            }
        }
        if (!bNew && bOld) {
            CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.workingConnections;
            synchronized (collectionSortedMap) {
                this.workingConnections.removeValue((Object)wrapper.getPriority(), (Object)wrapper);
                if (!this.workingConnections.isEmpty()) {
                    this.jobScheduler.setHighestPriority((Integer)this.workingConnections.firstKey());
                }
            }
        }
        if (newStatus == JPPFClientConnectionStatus.ACTIVE) {
            if (debugEnabled) {
                log.debug("processing active status for {}", (Object)wrapper);
            }
            wrapper.initChannelID();
            if (debugEnabled) {
                log.debug("about to add idle channel {}", (Object)wrapper);
            }
            this.jobScheduler.addIdleChannel(wrapper);
        } else {
            this.jobScheduler.removeIdleChannel(wrapper);
            if (newStatus.isTerminatedStatus() || newStatus == JPPFClientConnectionStatus.DISCONNECTED) {
                this.queue.cancelBroadcastJobs(wrapper.getUuid());
            }
        }
        this.jobScheduler.wakeUp();
    }

    @Override
    public String submitJob(JPPFJob job) {
        return this.submitJob(job, null);
    }

    @Override
    public String submitJob(JPPFJob job, JobStatusListener listener) {
        if (this.closed.get()) {
            throw new IllegalStateException("this jobmanager was closed");
        }
        if (debugEnabled) {
            log.debug("submitting job {}", (Object)job);
        }
        if (listener != null) {
            job.addJobStatusListener(listener);
        }
        List<Task<?>> tasks = job.getJobTasks();
        ArrayList pendingTasks = new ArrayList(tasks.size());
        for (Task<?> task : tasks) {
            if (job.getResults().hasResult(task.getPosition())) continue;
            pendingTasks.add(task);
        }
        this.queue.addBundle(new ClientJob(job, pendingTasks));
        return job.getUuid();
    }

    @Override
    public String resubmitJob(JPPFJob job) {
        return this.submitJob(job);
    }

    @Override
    public boolean cancelJob(String jobId) throws Exception {
        if (debugEnabled) {
            log.debug("requesting cancel of jobId=" + jobId);
        }
        this.queue.cancelJob(jobId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailableConnection() {
        boolean localConnectionavailable;
        JobManagerClient jobManagerClient = this;
        synchronized (jobManagerClient) {
            localConnectionavailable = this.wrapperLocal != null && this.wrapperLocal.getStatus() == JPPFClientConnectionStatus.ACTIVE;
        }
        return this.jobScheduler.hasIdleChannel() || localConnectionavailable;
    }

    @Override
    public synchronized boolean isLocalExecutionEnabled() {
        return this.localEnabled;
    }

    @Override
    public synchronized void setLocalExecutionEnabled(boolean localExecutionEnabled) {
        if (debugEnabled) {
            log.debug("setting localExecutionEnabled = {}", (Object)localExecutionEnabled);
        }
        if (this.localEnabled == localExecutionEnabled) {
            return;
        }
        this.localEnabled = localExecutionEnabled;
        this.updateLocalExecution(this.localEnabled);
    }

    private void updateLocalExecution(boolean localExecutionEnabled) {
        if (this.closed.get()) {
            throw new IllegalStateException("this job manager was closed");
        }
        if (localExecutionEnabled) {
            this.wrapperLocal = new ChannelWrapperLocal(this.client);
            this.wrapperLocal.addClientConnectionStatusListener(this.statusListener);
            this.addConnection(this.wrapperLocal);
        } else if (this.wrapperLocal != null) {
            try {
                this.wrapperLocal.close();
            }
            finally {
                this.removeConnection(this.wrapperLocal);
                this.wrapperLocal = null;
            }
        }
    }

    public int nbAvailableConnections() {
        return this.jobScheduler.getNbIdleChannels();
    }

    @Override
    public Vector<JPPFClientConnection> getAvailableConnections() {
        List<ChannelWrapper> idleChannels = this.jobScheduler.getIdleChannels();
        Vector<JPPFClientConnection> availableConnections = new Vector<JPPFClientConnection>(idleChannels.size());
        for (ChannelWrapper idleChannel : idleChannels) {
            if (idleChannel.isLocal()) continue;
            AbstractChannelWrapperRemote wrapperRemote = (AbstractChannelWrapperRemote)idleChannel;
            availableConnections.add(wrapperRemote.getChannel());
        }
        return availableConnections;
    }

    @Override
    public ClientConnectionStatusListener getClientConnectionStatusListener() {
        return this.statusListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.allConnections;
        synchronized (collectionSortedMap) {
            for (ChannelWrapper channel : this.allConnections) {
                channel.setResetting(true);
                channel.close();
            }
            this.allConnections.clear();
            if (this.jobScheduler != null) {
                this.jobScheduler.clearChannels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing {}", (Object)this);
        }
        this.closed.set(true);
        this.setStopped(true);
        this.wakeUp();
        if (this.jobScheduler != null) {
            this.jobScheduler.setStopped(true);
            this.jobScheduler.wakeUp();
        }
        this.queue.close();
        CollectionSortedMap<Integer, ChannelWrapper> collectionSortedMap = this.allConnections;
        synchronized (collectionSortedMap) {
            for (ChannelWrapper channel : this.allConnections) {
                channel.close();
            }
            this.allConnections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancingInformation getLoadBalancerSettings() {
        Object object = this.loadBalancingInformationLock;
        synchronized (object) {
            if (this.currentLoadBalancingInformation == null) {
                LoadBalancingInformation info = this.bundlerFactory.getCurrentInfo();
                this.currentLoadBalancingInformation = new LoadBalancingInformation(info.getAlgorithm(), info.getParameters(), this.bundlerFactory.getBundlerProviderNames());
            }
            return this.currentLoadBalancingInformation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoadBalancerSettings(String algorithm, Properties parameters) throws Exception {
        if (algorithm == null) {
            throw new IllegalArgumentException("Error: no algorithm specified (null value)");
        }
        if (!this.bundlerFactory.getBundlerProviderNames().contains(algorithm)) {
            throw new IllegalArgumentException("Error: unknown algorithm '" + algorithm + '\'');
        }
        TypedProperties props = parameters == null ? new TypedProperties() : new TypedProperties((Map)parameters);
        Object object = this.loadBalancingInformationLock;
        synchronized (object) {
            LoadBalancingInformation lbi = new LoadBalancingInformation(algorithm, props, this.currentLoadBalancingInformation.getAlgorithmNames());
            this.currentLoadBalancingInformation = this.bundlerFactory.setAndGetCurrentInfo(lbi);
        }
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public JPPFPriorityQueue getQueue() {
        return this.queue;
    }
}

