/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.node.protocol.TaskState;

public class TaskStateMap
extends TreeMap<Integer, TaskState> {
    private static final long serialVersionUID = 1L;
    private final Map<TaskState, AtomicInteger> stateCounts = new EnumMap<TaskState, AtomicInteger>(TaskState.class);

    public TaskStateMap() {
        for (TaskState state : TaskState.values()) {
            this.stateCounts.put(state, new AtomicInteger(0));
        }
    }

    @Override
    public TaskState put(Integer key, TaskState state) {
        if (state != null) {
            this.stateCounts.get(state).incrementAndGet();
        }
        return super.put(key, state);
    }

    @Override
    public TaskState remove(Object key) {
        TaskState state = (TaskState)super.remove(key);
        if (state != null) {
            this.stateCounts.get(state).decrementAndGet();
        }
        return state;
    }

    public int getStateCount(TaskState state) {
        if (state == null) {
            return 0;
        }
        return this.stateCounts.get(state).get();
    }

    @Override
    public void clear() {
        super.clear();
        for (TaskState state : TaskState.values()) {
            this.stateCounts.get(state).set(0);
        }
    }
}

