/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobStatus;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.JobManagerClient;
import org.jppf.client.balancer.queue.ScheduleManager;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorStatus;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.node.protocol.JobSLA;
import org.jppf.queue.AbstractJPPFQueue;
import org.jppf.queue.JPPFQueue;
import org.jppf.queue.QueueEvent;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPriorityQueue
extends AbstractJPPFQueue<ClientJob, ClientJob, ClientTaskBundle> {
    private static final Logger log = LoggerFactory.getLogger(JPPFPriorityQueue.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JobManagerClient jobManager;
    private final ScheduleManager scheduleManager = new ScheduleManager();
    private final ConcurrentHashMap<String, ClientJob> pendingBroadcasts = new ConcurrentHashMap();

    public JPPFPriorityQueue(JobManagerClient jobManager) {
        this.jobManager = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientJob addBundle(ClientJob clientJob) {
        JobSLA sla = clientJob.getSLA();
        String jobUuid = clientJob.getUuid();
        if (sla.isBroadcastJob() && clientJob.getBroadcastUUID() == null) {
            if (debugEnabled) {
                log.debug("before processing broadcast job " + clientJob.getJob());
            }
            this.processBroadcastJob(clientJob, this.jobManager.getWorkingRemoteConnections());
        } else {
            this.lock.lock();
            try {
                this.prepareClientJob(clientJob);
                if (!sla.isBroadcastJob() || clientJob.getBroadcastUUID() != null) {
                    this.priorityMap.putValue((Object)sla.getPriority(), (Object)clientJob);
                    this.incrementSizeCount(this.getSize(clientJob));
                    if (debugEnabled) {
                        log.debug("adding bundle with " + clientJob);
                    }
                    this.scheduleManager.handleStartJobSchedule(clientJob);
                    this.scheduleManager.handleExpirationJobSchedule(clientJob);
                }
                this.jobMap.put(jobUuid, clientJob);
                this.updateLatestMaxSize();
                this.fireBundleAdded(new QueueEvent((JPPFQueue)this, (Object)clientJob, false));
                if (debugEnabled) {
                    log.debug("Maps size information: " + CollectionUtils.formatSizeMapInfo((String)"priorityMap", (CollectionMap)this.priorityMap));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return clientJob;
    }

    protected void requeue(ClientJob job) {
        this.lock.lock();
        try {
            if (!this.jobMap.containsKey(job.getUuid())) {
                log.warn("Job not managed: {}", (Object)job);
            }
            if (debugEnabled) {
                log.debug("requeueing job {}", (Object)job);
            }
            this.priorityMap.putValue((Object)job.getSLA().getPriority(), (Object)job);
            this.incrementSizeCount(this.getSize(job));
            this.fireBundleAdded(new QueueEvent((JPPFQueue)this, (Object)job, true));
            job.jobRequeued();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTaskBundle nextBundle(ClientJob job, int nbTasks, ExecutorChannel<ClientTaskBundle> channel) {
        ClientTaskBundle result;
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("requesting bundle with {} tasks, next bundle has {} tasks", (Object)nbTasks, (Object)job.getTaskCount());
            }
            int size = this.getSize(job);
            this.decrementSizeCount(size);
            int effectiveNbTasks = nbTasks;
            if (job.getTaskGraph() != null) {
                int n = effectiveNbTasks = job.getClientSLA().isGraphTraversalInClient() || channel.isLocal() ? job.getAvailableGraphNodeCount() : job.getTaskCount();
            }
            if (debugEnabled) {
                log.debug("nbTasks={}, effectiveNbTasks={}", (Object)nbTasks, (Object)effectiveNbTasks);
            }
            if (effectiveNbTasks >= job.getTaskCount()) {
                job.setOnRequeue(() -> this.requeue(job));
                result = job.copy(job.getTaskCount());
                this.removeBundle(job);
            } else {
                if (debugEnabled) {
                    log.debug("removing {} tasks from bundle", (Object)effectiveNbTasks);
                }
                result = job.copy(effectiveNbTasks);
                this.incrementSizeCount(size);
                this.priorityMap.moveToEndOfList((Object)job.getSLA().getPriority(), (Object)job);
            }
            this.updateLatestMaxSize();
            if (debugEnabled) {
                log.debug("Maps size information: " + CollectionUtils.formatSizeMapInfo((String)"priorityMap", (CollectionMap)this.priorityMap));
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.priorityMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int getSize(ClientJob job) {
        return job.getJob().getJobTasks().size();
    }

    public ClientJob removeBundle(ClientJob job) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("removing bundle from queue, jobId=" + job.getName());
            }
            this.priorityMap.removeValue((Object)job.getSLA().getPriority(), (Object)job);
            this.fireBundleRemoved(new QueueEvent((JPPFQueue)this, (Object)job, false));
            ClientJob clientJob = job;
            return clientJob;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBroadcastJob(ClientJob clientJob, List<ChannelWrapper> workingRemoteConnections) {
        this.scheduleManager.handleStartJobSchedule(clientJob);
        this.scheduleManager.handleExpirationJobSchedule(clientJob);
        JPPFJob bundle = clientJob.getJob();
        List<ChannelWrapper> connections = this.jobManager.getAllConnections();
        Iterator<ChannelWrapper> it = connections.iterator();
        while (it.hasNext()) {
            ChannelWrapper ch = it.next();
            ExecutorStatus status = ch.getExecutionStatus();
            if (!ch.isLocal() && (status == ExecutorStatus.ACTIVE || status == ExecutorStatus.EXECUTING)) continue;
            it.remove();
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("%d connection(s) for broadcast job '%s' : %s", connections.size(), bundle.getName(), connections));
        }
        if (connections.isEmpty()) {
            this.pendingBroadcasts.putIfAbsent(bundle.getUuid(), clientJob);
            return;
        }
        this.pendingBroadcasts.remove(bundle.getUuid());
        JobSLA sla = bundle.getSLA();
        ArrayList<ClientJob> jobList = new ArrayList<ClientJob>(connections.size());
        HashSet<String> uuidSet = new HashSet<String>();
        for (ChannelWrapper connection : connections) {
            String uuid = connection.getUuid();
            if (uuid == null || uuid.length() <= 0 || !uuidSet.add(uuid)) continue;
            ClientJob newBundle = clientJob.createBroadcastJob(uuid);
            JPPFManagementInfo info = connection.getManagementInfo();
            newBundle.setClientSLA(bundle.getClientSLA().copy());
            newBundle.setSLA(sla.copy());
            newBundle.setMetadata(bundle.getMetadata());
            newBundle.setName(bundle.getName() + " [driver: " + info.toString() + ']');
            newBundle.setUuid(JPPFUuid.normalUUID());
            jobList.add(newBundle);
        }
        if (jobList.isEmpty()) {
            clientJob.taskCompleted(null, null);
        } else {
            String jobUuid = clientJob.getUuid();
            this.lock.lock();
            try {
                this.prepareClientJob(clientJob);
                this.jobMap.put(jobUuid, clientJob);
                this.fireBundleAdded(new QueueEvent((JPPFQueue)this, (Object)clientJob, false));
                for (ClientJob job : jobList) {
                    this.addBundle(job);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void prepareClientJob(ClientJob clientJob) {
        ClientJob other = (ClientJob)this.jobMap.get(clientJob.getUuid());
        if (other != null) {
            throw new IllegalStateException("Job " + clientJob.getUuid() + " already enqueued");
        }
        clientJob.addOnDone(() -> {
            this.lock.lock();
            try {
                this.jobMap.remove(clientJob.getUuid());
                this.removeBundle(clientJob);
            }
            finally {
                this.lock.unlock();
            }
        });
        clientJob.setJobStatus(JobStatus.PENDING);
        clientJob.setQueueEntryTime(System.currentTimeMillis());
        clientJob.setJobReceivedTime(clientJob.getQueueEntryTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePriority(String jobUuid, int newPriority) {
        this.lock.lock();
        try {
            ClientJob job = (ClientJob)this.jobMap.get(jobUuid);
            if (job == null) {
                return;
            }
            int oldPriority = job.getJob().getSLA().getPriority();
            if (oldPriority != newPriority) {
                job.getJob().getSLA().setPriority(newPriority);
                this.priorityMap.removeValue((Object)oldPriority, (Object)job);
                this.priorityMap.putValue((Object)newPriority, (Object)job);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelJob(String jobId) {
        if (debugEnabled) {
            log.debug("requesting cancel of jobId=" + jobId);
        }
        this.lock.lock();
        try {
            ClientJob job = (ClientJob)this.jobMap.get(jobId);
            boolean bl = job == null ? false : job.cancel(false);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.lock.lock();
        try {
            this.scheduleManager.close();
            this.pendingBroadcasts.clear();
            this.jobMap.clear();
            this.priorityMap.clear();
            this.sizeMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBroadcastJobs(String connectionUUID) {
        if (connectionUUID == null || connectionUUID.isEmpty()) {
            return;
        }
        Set<String> jobIDs = Collections.emptySet();
        this.lock.lock();
        try {
            if (this.jobMap.isEmpty()) {
                return;
            }
            jobIDs = new HashSet<String>();
            for (Map.Entry entry : this.jobMap.entrySet()) {
                if (!connectionUUID.equals(((ClientJob)entry.getValue()).getBroadcastUUID())) continue;
                jobIDs.add((String)entry.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
        for (String jobID : jobIDs) {
            this.cancelJob(jobID);
        }
    }

    public void processPendingBroadcasts() {
        if (!this.jobManager.hasWorkingConnection() || this.pendingBroadcasts.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ClientJob> entry : this.pendingBroadcasts.entrySet()) {
            ClientJob clientJob = entry.getValue();
            if (log.isTraceEnabled()) {
                log.trace("queuing broadcast job " + clientJob.getJob());
            }
            this.processBroadcastJob(clientJob, this.jobManager.getWorkingRemoteConnections());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFJob> getJPPFJobs() {
        this.lock.lock();
        try {
            int size = this.priorityMap.size();
            if (size <= 0) {
                List<JPPFJob> list = Collections.emptyList();
                return list;
            }
            ArrayList<JPPFJob> list = new ArrayList<JPPFJob>(size);
            for (ClientJob clientJob : this.priorityMap) {
                list.add(clientJob.getJob());
            }
            ArrayList<JPPFJob> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

