/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import org.jppf.client.JPPFContextClient;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.AbstractClientJob;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.execute.ExecutorStatus;
import org.jppf.load.balancer.JPPFContext;
import org.jppf.load.balancer.JobAwareness;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.policy.Preference;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.queue.JPPFQueue;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.PropertiesCollection;
import org.jppf.utils.collections.DescendingIntegerComparator;
import org.jppf.utils.collections.LinkedListSortedMap;
import org.jppf.utils.concurrent.JPPFThreadFactory;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduler
extends ThreadSynchronization
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobScheduler.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private final Random random = new Random(System.nanoTime());
    private final JPPFPriorityQueue queue;
    private final Lock queueLock;
    private final LinkedListSortedMap<Integer, ChannelWrapper> idleChannels = new LinkedListSortedMap((Comparator)new DescendingIntegerComparator());
    private final JPPFContext jppfContext;
    private final ExecutorService channelsExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("ChannelsExecutor"));
    private final JPPFBundlerFactory bundlerFactory;
    private int highestPriority = Integer.MIN_VALUE;
    private final Object priorityLock = new Object();
    private final BlockingQueue<Runnable> pendingActions = new LinkedBlockingQueue<Runnable>();

    public JobScheduler(JPPFPriorityQueue queue, JPPFBundlerFactory bundlerFactory) {
        this.queue = queue;
        this.bundlerFactory = bundlerFactory;
        this.jppfContext = new JPPFContextClient((JPPFQueue<ClientJob, ClientJob, ClientTaskBundle>)queue);
        this.queueLock = queue.getLock();
    }

    public JPPFContext getJPPFContext() {
        return this.jppfContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighestPriority(int priority) {
        Object object = this.priorityLock;
        synchronized (object) {
            this.highestPriority = priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHighestPriority() {
        Object object = this.priorityLock;
        synchronized (object) {
            return this.highestPriority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbIdleChannels() {
        LinkedListSortedMap<Integer, ChannelWrapper> linkedListSortedMap = this.idleChannels;
        synchronized (linkedListSortedMap) {
            return this.idleChannels.size();
        }
    }

    public void addIdleChannel(ChannelWrapper channel) {
        if (debugEnabled) {
            log.debug("adding channel {}", (Object)channel);
        }
        if (this.channelsExecutor == null || this.channelsExecutor.isShutdown() || this.isStopped()) {
            return;
        }
        if (channel == null) {
            log.warn("channel is null\n{}", (Object)ExceptionUtils.getCallStack());
            return;
        }
        ExecutorStatus status = channel.getExecutionStatus();
        if (status != ExecutorStatus.ACTIVE) {
            log.warn("channel is not active ({})\n{}", (Object)channel, (Object)ExceptionUtils.getCallStack());
            return;
        }
        this.pendingActions.offer(() -> {
            if (debugEnabled) {
                log.debug("Adding idle channel {}", (Object)channel);
            }
            this.idleChannels.putValue((Object)channel.getPriority(), (Object)channel);
        });
        this.wakeUp();
    }

    public void removeIdleChannel(ChannelWrapper channel) {
        if (debugEnabled) {
            log.debug("removing chhanel {}", (Object)channel);
        }
        if (this.channelsExecutor == null || this.channelsExecutor.isShutdown() || this.isStopped()) {
            return;
        }
        this.pendingActions.offer(() -> {
            if (debugEnabled) {
                log.debug("Removing idle channel {}", (Object)channel);
            }
            this.idleChannels.removeValue((Object)channel.getPriority(), (Object)channel);
        });
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelWrapper> getIdleChannels() {
        LinkedListSortedMap<Integer, ChannelWrapper> linkedListSortedMap = this.idleChannels;
        synchronized (linkedListSortedMap) {
            return this.idleChannels.allValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIdleChannel() {
        LinkedListSortedMap<Integer, ChannelWrapper> linkedListSortedMap = this.idleChannels;
        synchronized (linkedListSortedMap) {
            return !this.idleChannels.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChannels() {
        LinkedListSortedMap<Integer, ChannelWrapper> linkedListSortedMap = this.idleChannels;
        synchronized (linkedListSortedMap) {
            this.idleChannels.clear();
        }
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            if (this.dispatch()) continue;
            this.goToSleep(1000L);
        }
        if (this.channelsExecutor != null) {
            this.channelsExecutor.shutdownNow();
        }
        this.clearChannels();
    }

    private void processPendingActions() {
        Runnable r;
        while ((r = (Runnable)this.pendingActions.poll()) != null) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch() {
        boolean dispatched = false;
        try {
            this.queue.processPendingBroadcasts();
            LinkedListSortedMap<Integer, ChannelWrapper> linkedListSortedMap = this.idleChannels;
            synchronized (linkedListSortedMap) {
                this.processPendingActions();
                if (this.idleChannels.isEmpty() || this.queue.isEmpty()) {
                    return false;
                }
                if (debugEnabled) {
                    int nbChannels;
                    int size = this.idleChannels.size();
                    Integer firstKey = (Integer)this.idleChannels.firstKey();
                    int highestPriority = this.getHighestPriority();
                    Collection channels = this.idleChannels.getValues((Object)highestPriority);
                    int n = nbChannels = channels == null ? 0 : channels.size();
                    if (size <= 5) {
                        log.debug("nb idle channels = {}, firstKey = {}, highestPriority = {} ==> {} channels: {}", new Object[]{size, firstKey, highestPriority, nbChannels, channels});
                    } else {
                        log.debug("nb idle channels = {}, firstKey = {}, highestPriority = {} ==> {} channels", new Object[]{size, firstKey, highestPriority, nbChannels});
                    }
                }
                ChannelWrapper channel = null;
                AbstractClientJob selectedBundle = null;
                this.queueLock.lock();
                try {
                    Iterator jobIterator = this.queue.iterator();
                    while (channel == null && jobIterator.hasNext() && !this.idleChannels.isEmpty()) {
                        ClientJob job = (ClientJob)jobIterator.next();
                        if (debugEnabled) {
                            log.debug("looking for eligible channels for job {}", (Object)job);
                        }
                        if (job.isCancellingOrCancelled() || job.getTaskGraph() != null && !job.hasAvvailableGraphNode()) continue;
                        channel = this.findIdleChannel(job);
                        if (job.isCancellingOrCancelled()) continue;
                        if (channel != null) {
                            selectedBundle = job;
                            continue;
                        }
                        if (!traceEnabled) continue;
                        log.trace("no channel found for job {}", (Object)job);
                    }
                    if (debugEnabled) {
                        log.debug(channel == null ? "no channel found for bundle" : "channel found for bundle: " + channel);
                    }
                    if (channel != null && selectedBundle != null && !selectedBundle.isCancellingOrCancelled()) {
                        dispatched = this.dispatchJobToChannel(channel, (ClientJob)selectedBundle);
                    }
                }
                catch (Exception ex) {
                    log.error("An error occurred while attempting to dispatch task bundles. This is most likely due to an error in the load balancer implementation.", (Throwable)ex);
                }
                finally {
                    this.queueLock.unlock();
                }
            }
        }
        catch (Exception ex) {
            log.error("An error occurred while preparing for bundle creation and dispatching.", (Throwable)ex);
        }
        return dispatched;
    }

    private ChannelWrapper findIdleChannel(ClientJob job) {
        int idleChannelsSize = this.idleChannels.size();
        ArrayList<ChannelWrapper> acceptableChannels = new ArrayList<ChannelWrapper>(idleChannelsSize);
        int highestPriority = this.getHighestPriority();
        Collection<ChannelWrapper> channels = this.idleChannels.getValues((Object)highestPriority);
        if (channels == null) {
            return null;
        }
        if ((channels = JobScheduler.filterPreferredChannels(channels, job)).isEmpty()) {
            return null;
        }
        for (ChannelWrapper ch : channels) {
            if (ch.getExecutionStatus() != ExecutorStatus.ACTIVE) {
                if (debugEnabled) {
                    log.debug("channel is not opened, removing it: {}", (Object)ch);
                }
                this.idleChannels.removeValue((Object)ch.getPriority(), (Object)ch);
                continue;
            }
            if (ch.getCurrentNbJobs() >= ch.getMaxJobs() || !job.acceptsChannel(ch)) continue;
            if (job.getBroadcastUUID() != null && !job.getBroadcastUUID().equals(ch.getUuid())) {
                if (!traceEnabled) continue;
                log.trace("broadcast job {} not matching channel", (Object)job);
                continue;
            }
            acceptableChannels.add(ch);
        }
        this.processPendingActions();
        int size = acceptableChannels.size();
        if (debugEnabled) {
            log.debug("found " + size + " acceptable channels");
        }
        return size > 0 ? (ChannelWrapper)acceptableChannels.get(size > 1 ? this.random.nextInt(size) : 0) : null;
    }

    private boolean dispatchJobToChannel(ChannelWrapper channel, ClientJob job) throws Exception {
        if (debugEnabled) {
            log.debug("dispatching jobUuid={} to channel {}, connectionUuid=", new Object[]{job.getJob().getUuid(), channel, channel.getConnectionUuid()});
        }
        int size = 1;
        if (job.isCancellingOrCancelled()) {
            return false;
        }
        try {
            this.updateBundler(job.getJob(), channel);
            size = channel.getBundler().getBundleSize();
            if (job.getClientSLA().getMaxDispatchSize() < size) {
                size = job.getClientSLA().getMaxDispatchSize();
            }
        }
        catch (Exception e) {
            log.error("Error in load balancer implementation, switching to 'manual' with a bundle size of 1: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            size = this.bundlerFactory.getFallbackBundler().getBundleSize();
        }
        if (job.isCancellingOrCancelled()) {
            return false;
        }
        ClientTaskBundle jobDispatch = this.queue.nextBundle(job, size, channel);
        job.addChannel(channel);
        channel.submit((Object)jobDispatch);
        return true;
    }

    private void updateBundler(JPPFJob job, ChannelWrapper channel) {
        channel.checkBundler(this.bundlerFactory, this.jppfContext);
        if (channel.getBundler() instanceof JobAwareness) {
            ((JobAwareness)channel.getBundler()).setJob((JPPFDistributedJob)job);
        }
    }

    private static Collection<ChannelWrapper> filterPreferredChannels(Collection<ChannelWrapper> idleChannels, ClientJob job) {
        if (idleChannels == null || idleChannels.isEmpty()) {
            return Collections.emptyList();
        }
        Preference preference = job.getClientSLA().getPreferencePolicy();
        if (preference == null) {
            return idleChannels;
        }
        ArrayList<ChannelWrapper> result = new ArrayList<ChannelWrapper>(idleChannels.size());
        for (ExecutionPolicy policy : preference.getChildren()) {
            for (ChannelWrapper channel : idleChannels) {
                job.preparePolicy(policy);
                if (!policy.accepts((PropertiesCollection)channel.getSystemInformation())) continue;
                result.add(channel);
            }
            if (!result.isEmpty()) break;
        }
        return result;
    }
}

