/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFException;
import org.jppf.client.JPPFJob;
import org.jppf.client.concurrent.ExecutorServiceConfiguration;
import org.jppf.client.concurrent.ExecutorServiceConfigurationImpl;
import org.jppf.client.concurrent.JPPFExecutorService;
import org.jppf.client.concurrent.JPPFTaskFuture;
import org.jppf.client.concurrent.JobConfiguration;
import org.jppf.client.concurrent.TaskConfiguration;
import org.jppf.client.event.JobListener;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.node.protocol.Task;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Pair;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchHandler
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(BatchHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final AtomicLong JOB_COUNT = new AtomicLong(0L);
    private int batchSize;
    private long batchTimeout;
    private final JPPFExecutorService executor;
    private final AtomicReference<JPPFJob> currentJobRef = new AtomicReference<Object>(null);
    private final AtomicReference<JPPFJob> nextJobRef = new AtomicReference<Object>(null);
    private long start;
    private long elapsed;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition jobReady = this.lock.newCondition();
    private final Condition submittingJob = this.lock.newCondition();
    private ExecutorServiceConfiguration config = new ExecutorServiceConfigurationImpl();

    BatchHandler(JPPFExecutorService executor) {
        this(executor, 0, 0L);
    }

    BatchHandler(JPPFExecutorService executor, int batchSize, long batchTimeout) {
        this.executor = executor;
        this.batchSize = batchSize;
        this.batchTimeout = batchTimeout;
        this.resetTimeout();
        this.nextJobRef.set(this.createJob());
    }

    int getBatchSize() {
        this.lock.lock();
        try {
            int n = this.batchSize;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setBatchSize(int batchSize) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("setting batchSize = {}", (Object)batchSize);
            }
            this.batchSize = batchSize;
            this.jobReady.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    long getBatchTimeout() {
        this.lock.lock();
        try {
            long l = this.batchTimeout;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setBatchTimeout(long batchTimeout) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("setting batchTimeout = {}", (Object)batchTimeout);
            }
            if (this.batchTimeout <= 0L) {
                this.resetTimeout();
            }
            this.batchTimeout = batchTimeout;
            this.jobReady.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.start = System.nanoTime();
        while (!this.isStopped()) {
            try {
                this.lock.lock();
                try {
                    JPPFJob job = null;
                    while (!this.isStopped() && (job = this.currentJobRef.get()) == null) {
                        long batchTimeout = this.getBatchTimeout();
                        if (batchTimeout > 0L) {
                            long n = batchTimeout - this.elapsed;
                            if (n > 0L) {
                                this.jobReady.await(n, TimeUnit.MILLISECONDS);
                            }
                        } else {
                            this.jobReady.await();
                        }
                        this.updateNextJob(false);
                    }
                    if (this.isStopped()) break;
                    if (debugEnabled) {
                        log.debug("submitting job {} with {} tasks", (Object)job.getName(), (Object)job.getJobTasks().size());
                    }
                    this.configureJob(job);
                    this.executor.submitJob(job);
                    this.currentJobRef.set(null);
                    this.elapsed = (System.nanoTime() - this.start) / 1000000L;
                    this.submittingJob.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateNextJob(boolean sendSignal) {
        JPPFJob job = this.nextJobRef.get();
        int size = job.getJobTasks().size();
        long batchTimeout = this.getBatchTimeout();
        int batchSize = this.getBatchSize();
        if (batchTimeout > 0L) {
            this.elapsed = (System.nanoTime() - this.start) / 1000000L;
        }
        if (size == 0) {
            if (batchTimeout > 0L && this.elapsed >= batchTimeout) {
                this.resetTimeout();
            }
            return;
        }
        if (batchTimeout > 0L && this.elapsed >= batchTimeout || batchSize > 0 && size >= batchSize || batchSize <= 0 && batchTimeout <= 0L) {
            if (debugEnabled) {
                log.debug("preparing job {} for submission, batchTimeout={}, elapsed={}, batchSize={}, size={}", new Object[]{job.getName(), batchTimeout, this.elapsed, batchSize, size});
            }
            this.currentJobRef.set(job);
            this.nextJobRef.set(this.createJob());
            this.resetTimeout();
            if (sendSignal) {
                this.jobReady.signal();
                try {
                    this.submittingJob.await();
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        }
    }

    private void resetTimeout() {
        this.start = System.nanoTime();
        this.elapsed = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(Task<?> task, T result) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting JPPF task");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                job.add(task);
                future = new JPPFTaskFuture(job, task.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(Runnable task, T result) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting Runnable task with result");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                JPPFAnnotatedTask t = (JPPFAnnotatedTask)job.add(task);
                t.setResult(result);
                this.configureTask(t);
                future = new JPPFTaskFuture(job, t.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> addTask(Callable<T> task) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting Callable task");
            }
            JPPFTaskFuture future = null;
            JPPFJob job = this.nextJobRef.get();
            try {
                JPPFAnnotatedTask jppfTask = (JPPFAnnotatedTask)job.add(task);
                this.configureTask(jppfTask);
                future = new JPPFTaskFuture(job, jppfTask.getPosition());
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            this.updateNextJob(true);
            JPPFTaskFuture jPPFTaskFuture = future;
            return jPPFTaskFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Pair<JPPFJob, Integer> addTasks(Collection<? extends Callable<T>> tasks) {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("submitting " + tasks.size() + " Callable tasks");
            }
            Pair pair = null;
            JPPFJob job = this.nextJobRef.get();
            int start = 0;
            try {
                List<Task<?>> jobTasks = job.getJobTasks();
                start = jobTasks.size();
                for (Callable<T> task : tasks) {
                    Task<?> t = job.add(task);
                    this.configureTask((JPPFAnnotatedTask)t);
                }
            }
            catch (JPPFException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RejectedExecutionException(e);
            }
            pair = new Pair((Object)job, (Object)start);
            this.updateNextJob(true);
            Pair pair2 = pair;
            return pair2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private JPPFJob createJob() {
        JPPFJob job = new JPPFJob();
        job.setName(this.getClass().getSimpleName() + " job " + JOB_COUNT.incrementAndGet());
        job.addJobListener(this.executor);
        if (debugEnabled) {
            log.debug("created job " + job);
        }
        return job;
    }

    private synchronized void configureJob(JPPFJob job) {
        if (this.config != null) {
            JobConfiguration jc = this.config.getJobConfiguration();
            job.setSLA(jc.getSLA());
            job.setClientSLA(jc.getClientSLA());
            job.setMetadata(jc.getMetadata());
            job.setPersistenceManager(jc.getPersistenceManager());
            job.setDataProvider(jc.getDataProvider());
            for (JobListener listener : jc.getAllJobListeners()) {
                job.addJobListener(listener);
            }
            for (ClassLoader cl : jc.getClassLoaders()) {
                this.executor.client.registerClassLoader(cl, job.getUuid());
            }
        }
    }

    private synchronized void configureTask(JPPFAnnotatedTask task) {
        if (this.config != null) {
            TaskConfiguration tc = this.config.getTaskConfiguration();
            task.setCancelCallback(tc.getOnCancelCallback());
            task.setTimeoutCallback(tc.getOnTimeoutCallback());
            task.setTimeoutSchedule(tc.getTimeoutSchedule());
        }
    }

    void close() {
        this.setStopped(true);
        this.lock.lock();
        try {
            this.jobReady.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized ExecutorServiceConfiguration getConfig() {
        return this.config;
    }

    synchronized void setConfig(ExecutorServiceConfiguration config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.config = config;
    }

    synchronized ExecutorServiceConfiguration resetConfig() {
        this.config = new ExecutorServiceConfigurationImpl();
        return this.config;
    }
}

