/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jppf.client.concurrent.JobConfiguration;
import org.jppf.client.event.JobListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFJobMetadata;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;

class JobConfigurationImpl
implements JobConfiguration {
    private JobSLA jobSLA = new JobSLA();
    private JobClientSLA jobClientSLA = new JobClientSLA();
    private JobMetadata jobMetadata = new JPPFJobMetadata();
    private JobPersistence<?> persistenceManager;
    private DataProvider dataProvider;
    private List<JobListener> listeners = new LinkedList<JobListener>();
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    JobConfigurationImpl() {
    }

    JobConfigurationImpl(JobSLA sla, JobMetadata metadata, JobPersistence<?> persistenceManager) {
        this.jobSLA = sla;
        this.jobMetadata = metadata;
        this.persistenceManager = persistenceManager;
    }

    JobConfigurationImpl(JobConfiguration config) {
        this(config.getSLA(), config.getMetadata(), config.getPersistenceManager());
        this.setClientSLA(config.getClientSLA());
        for (JobListener listener : config.getAllJobListeners()) {
            this.addJobListener(listener);
        }
    }

    @Override
    public JobSLA getSLA() {
        return this.jobSLA;
    }

    @Override
    public JobConfiguration setSLA(JobSLA jobSLA) {
        this.jobSLA = jobSLA;
        return this;
    }

    @Override
    public JobClientSLA getClientSLA() {
        return this.jobClientSLA;
    }

    @Override
    public JobConfiguration setClientSLA(JobClientSLA jobClientSLA) {
        this.jobClientSLA = jobClientSLA;
        return this;
    }

    @Override
    public JobMetadata getMetadata() {
        return this.jobMetadata;
    }

    public void setMetadata(JobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    @Override
    public <T> JobPersistence<T> getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public <T> JobConfiguration setPersistenceManager(JobPersistence<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
        return this;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public JobConfiguration setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobConfiguration addJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobConfiguration removeJobListener(JobListener listener) {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JobListener> getAllJobListeners() {
        List<JobListener> list = this.listeners;
        synchronized (list) {
            return this.listeners;
        }
    }

    @Override
    public List<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }
}

