/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractComponent<E extends AbstractComponent>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Map<String, E> children = new HashMap<String, E>();
    protected transient E parent;
    protected final String uuid;

    protected AbstractComponent(String uuid) {
        this.uuid = uuid;
    }

    public synchronized E getParent() {
        return this.parent;
    }

    synchronized void setParent(E parent) {
        this.parent = parent;
    }

    public synchronized E getChild(String uuid) {
        return (E)((AbstractComponent)this.children.get(uuid));
    }

    public synchronized int getChildCount() {
        return this.children.size();
    }

    public synchronized List<E> getChildren() {
        return new ArrayList<E>(this.children.values());
    }

    public synchronized void add(E child) {
        this.children.put(child.getUuid(), child);
        child.setParent((AbstractComponent)this);
    }

    public synchronized void remove(E child) {
        if (child != null) {
            this.children.remove(((AbstractComponent)child).getUuid());
            ((AbstractComponent)child).setParent(null);
        }
    }

    public synchronized String getUuid() {
        return this.uuid;
    }

    public String getDisplayName() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractComponent other = (AbstractComponent)obj;
        if (this.uuid == null) {
            return other.getUuid() == null;
        }
        return this.uuid.equals(other.getUuid());
    }
}

