/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.HashMap;
import java.util.Map;
import org.jppf.client.monitoring.AbstractRefreshHandler;
import org.jppf.client.monitoring.jobs.AbstractJobNotificationsHandler;
import org.jppf.client.monitoring.jobs.Job;
import org.jppf.client.monitoring.jobs.JobDispatch;
import org.jppf.client.monitoring.jobs.JobDriver;
import org.jppf.client.monitoring.jobs.JobMonitor;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.job.JobInformation;
import org.jppf.job.JobNotification;
import org.jppf.management.JPPFManagementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeferredJobNotificationsHandler
extends AbstractJobNotificationsHandler {
    private static Logger log = LoggerFactory.getLogger(DeferredJobNotificationsHandler.class);
    final Map<String, DriverNotif> driverMap = new HashMap<String, DriverNotif>();
    final AbstractRefreshHandler refreshHandler;

    DeferredJobNotificationsHandler(JobMonitor monitor, String name, long period) {
        super(monitor);
        this.refreshHandler = new AbstractRefreshHandler(name, period){

            @Override
            protected void performRefresh() {
                DeferredJobNotificationsHandler.this.publish();
            }
        };
        this.refreshHandler.startRefreshTimer();
    }

    @Override
    void handleNotificationAsync(JobNotification notif) {
        try {
            JobInformation jobInfo = notif.getJobInformation();
            JobDriver driver = this.monitor.getJobDriver(notif.getDriverUuid());
            DriverNotif driverNotif = this.getDriverNotif(driver);
            JPPFManagementInfo nodeInfo = notif.getNodeInfo();
            switch (notif.getEventType()) {
                case JOB_QUEUED: {
                    this.handleJobNotif(jobInfo, driverNotif, JobNotificationType.ADD);
                    break;
                }
                case JOB_ENDED: {
                    this.handleJobNotif(jobInfo, driverNotif, JobNotificationType.REMOVE);
                    break;
                }
                case JOB_UPDATED: {
                    this.handleJobNotif(jobInfo, driverNotif, JobNotificationType.UPDATE);
                    break;
                }
                case JOB_DISPATCHED: {
                    this.handleJobDispatchNotif(jobInfo, nodeInfo, driverNotif, JobNotificationType.ADD);
                    break;
                }
                case JOB_RETURNED: {
                    this.handleJobDispatchNotif(jobInfo, nodeInfo, driverNotif, JobNotificationType.REMOVE);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        try {
            HashMap<String, DriverNotif> tmpMap = new HashMap<String, DriverNotif>();
            Map<String, DriverNotif> map = this.driverMap;
            synchronized (map) {
                for (DriverNotif driverNotif : this.driverMap.values()) {
                    DriverNotif tmpDriverNotif = new DriverNotif(driverNotif.driver);
                    tmpDriverNotif.jobs = driverNotif.jobs;
                    driverNotif.jobs = new HashMap<String, JobNotif>();
                    tmpMap.put(tmpDriverNotif.driver.getUuid(), tmpDriverNotif);
                }
            }
            if (tmpMap.isEmpty()) {
                return;
            }
            for (DriverNotif driverNotif : tmpMap.values()) {
                if (driverNotif.jobs.isEmpty()) continue;
                JobDriver driver = driverNotif.driver;
                Job job = null;
                for (JobNotif jn : driverNotif.jobs.values()) {
                    switch (jn.type) {
                        case ADD: {
                            job = new Job(jn.jobInformation);
                            this.monitor.jobAdded(driver, job);
                            break;
                        }
                        case REMOVE: {
                            job = driver.getJob(jn.jobInformation.getJobUuid());
                            if (job == null) break;
                            this.monitor.jobRemoved(driver, job);
                            break;
                        }
                        case UPDATE: {
                            job = driver.getJob(jn.jobInformation.getJobUuid());
                            if (job == null || !this.monitor.isJobUpdated(job.getJobInformation(), jn.jobInformation)) break;
                            job.setJobInformation(jn.jobInformation);
                            this.monitor.jobUpdated(driver, job);
                        }
                    }
                    if (jn.dispatches.isEmpty()) continue;
                    job = driver.getJob(jn.jobInformation.getJobUuid());
                    if (job != null) {
                        for (JobDispatchNotif jdn : jn.dispatches.values()) {
                            TopologyNode node = this.monitor.getTopologyManager().getNode(jdn.nodeInformation.getUuid());
                            switch (jdn.type) {
                                case ADD: {
                                    if (node == null) break;
                                    this.monitor.dispatchAdded(driver, job, new JobDispatch(jdn.jobInformation, node));
                                    break;
                                }
                                case REMOVE: {
                                    JobDispatch dispatch;
                                    if (node == null || (dispatch = job.getJobDispatch(node.getUuid())) == null) break;
                                    this.monitor.dispatchRemoved(driver, job, dispatch);
                                }
                            }
                        }
                    }
                    jn.dispatches.clear();
                }
                driverNotif.jobs.clear();
            }
            tmpMap.clear();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DriverNotif getDriverNotif(JobDriver driver) {
        Map<String, DriverNotif> map = this.driverMap;
        synchronized (map) {
            DriverNotif notif = this.driverMap.get(driver.getUuid());
            if (notif == null) {
                notif = new DriverNotif(driver);
                this.driverMap.put(driver.getUuid(), notif);
            }
            return notif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJobNotif(JobInformation jobInfo, DriverNotif driverNotif, JobNotificationType type) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("type=%s, jobInfo=%s, driverNotif=%s", new Object[]{type, jobInfo, driverNotif}));
        }
        JobNotif jn = new JobNotif(jobInfo, type);
        Map<String, DriverNotif> map = this.driverMap;
        synchronized (map) {
            JobNotif oldJN = driverNotif.jobs.get(jobInfo.getJobUuid());
            if (oldJN == null) {
                driverNotif.jobs.put(jobInfo.getJobUuid(), jn);
            } else {
                oldJN.merge(jn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJobDispatchNotif(JobInformation jobInfo, JPPFManagementInfo nodeInfo, DriverNotif driverNotif, JobNotificationType type) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("type=%s, jobInfo=%s, nodeInfo=%s, driverNotif=%s", new Object[]{type, jobInfo, nodeInfo, driverNotif}));
        }
        Map<String, DriverNotif> map = this.driverMap;
        synchronized (map) {
            JobNotif jn = driverNotif.jobs.get(jobInfo.getJobUuid());
            if (jn == null) {
                if (type == JobNotificationType.REMOVE) {
                    jn = new JobNotif(jobInfo, JobNotificationType.NONE);
                    driverNotif.jobs.put(jobInfo.getJobUuid(), jn);
                } else {
                    return;
                }
            }
            JobDispatchNotif jdn = new JobDispatchNotif(jobInfo, nodeInfo, type);
            JobDispatchNotif oldJDN = jn.dispatches.get(nodeInfo.getUuid());
            if (oldJDN == null) {
                jn.dispatches.put(nodeInfo.getUuid(), jdn);
            } else {
                oldJDN.merge(jdn);
            }
        }
    }

    static class JobDispatchNotif
    extends AbstractJobNotification<JobDispatchNotif> {
        JPPFManagementInfo nodeInformation;

        JobDispatchNotif(JobInformation jobInformation, JPPFManagementInfo nodeInformation, JobNotificationType type) {
            super(jobInformation, type);
            this.nodeInformation = nodeInformation;
        }

        @Override
        void merge(JobDispatchNotif notif) {
            this.type = this.type == JobNotificationType.ADD && notif.type == JobNotificationType.REMOVE ? JobNotificationType.NONE : (this.type == JobNotificationType.REMOVE && notif.type == JobNotificationType.ADD ? JobNotificationType.NONE : notif.type);
            this.jobInformation = notif.jobInformation;
            this.nodeInformation = notif.nodeInformation;
        }
    }

    static class JobNotif
    extends AbstractJobNotification<JobNotif> {
        final Map<String, JobDispatchNotif> dispatches = new HashMap<String, JobDispatchNotif>();

        JobNotif(JobInformation jobInformation, JobNotificationType type) {
            super(jobInformation, type);
        }

        @Override
        void merge(JobNotif notif) {
            this.type = this.type == JobNotificationType.ADD && notif.type == JobNotificationType.UPDATE ? JobNotificationType.ADD : (this.type == JobNotificationType.ADD && notif.type == JobNotificationType.REMOVE ? JobNotificationType.NONE : (this.type == JobNotificationType.REMOVE && notif.type == JobNotificationType.ADD ? JobNotificationType.NONE : notif.type));
            this.jobInformation = notif.jobInformation;
        }
    }

    static class DriverNotif {
        Map<String, JobNotif> jobs = new HashMap<String, JobNotif>();
        JobDriver driver;

        DriverNotif(JobDriver driver) {
            this.driver = driver;
        }
    }

    static abstract class AbstractJobNotification<N extends AbstractJobNotification<N>> {
        JobInformation jobInformation;
        JobNotificationType type;

        AbstractJobNotification(JobInformation jobInformation, JobNotificationType type) {
            this.jobInformation = jobInformation;
            this.type = type;
        }

        abstract void merge(N var1);
    }

    static enum JobNotificationType {
        ADD,
        REMOVE,
        UPDATE,
        NONE;

    }
}

