/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import org.jppf.client.monitoring.jobs.AbstractJobNotificationsHandler;
import org.jppf.client.monitoring.jobs.Job;
import org.jppf.client.monitoring.jobs.JobDispatch;
import org.jppf.client.monitoring.jobs.JobDriver;
import org.jppf.client.monitoring.jobs.JobMonitor;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.job.JobInformation;
import org.jppf.job.JobNotification;
import org.jppf.management.JPPFManagementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImmediateJobNotificationsHandler
extends AbstractJobNotificationsHandler {
    private static final Logger log = LoggerFactory.getLogger(ImmediateJobNotificationsHandler.class);
    private static final boolean traceEnabled = log.isTraceEnabled();

    ImmediateJobNotificationsHandler(JobMonitor monitor) {
        super(monitor);
    }

    @Override
    void handleNotificationAsync(JobNotification notif) {
        try {
            if (traceEnabled) {
                log.trace("handling {} notification: {}", (Object)notif.getEventType(), (Object)notif);
            }
            JobInformation jobInfo = notif.getJobInformation();
            JobDriver driver = this.monitor.getJobDriver(notif.getDriverUuid());
            if (driver == null) {
                return;
            }
            Job job = driver.getJob(jobInfo.getJobUuid());
            JPPFManagementInfo nodeInfo = notif.getNodeInfo();
            TopologyNode node = nodeInfo == null ? null : (TopologyNode)driver.getTopologyDriver().getChild(nodeInfo.getUuid());
            switch (notif.getEventType()) {
                case JOB_QUEUED: {
                    this.monitor.jobAdded(driver, new Job(jobInfo));
                    break;
                }
                case JOB_ENDED: {
                    this.monitor.jobRemoved(driver, job);
                    break;
                }
                case JOB_UPDATED: {
                    if (job == null || !this.monitor.isJobUpdated(job.getJobInformation(), jobInfo)) break;
                    job.setJobInformation(jobInfo);
                    this.monitor.jobUpdated(driver, job);
                    break;
                }
                case JOB_DISPATCHED: {
                    if (node == null) break;
                    this.monitor.dispatchAdded(driver, job, new JobDispatch(jobInfo, node));
                    break;
                }
                case JOB_RETURNED: {
                    if (node == null || job == null) break;
                    this.monitor.dispatchRemoved(driver, job, job.getJobDispatch(node.getUuid()));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

