/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.monitoring.jobs.AbstractJobComponent;
import org.jppf.client.monitoring.jobs.JobDispatch;
import org.jppf.client.monitoring.jobs.JobDriver;
import org.jppf.job.JobInformation;

public class Job
extends AbstractJobComponent {
    private static final long serialVersionUID = 1L;
    private transient JobInformation jobInfo;

    Job(JobInformation jobInfo) {
        super(jobInfo.getJobUuid());
        this.jobInfo = jobInfo;
    }

    synchronized void setJobInformation(JobInformation jobInfo) {
        this.jobInfo = jobInfo;
    }

    public synchronized JobInformation getJobInformation() {
        return this.jobInfo;
    }

    public JobDriver getJobDriver() {
        return (JobDriver)this.getParent();
    }

    public JobDispatch getJobDispatch(String nodeUuid) {
        return (JobDispatch)this.getChild(nodeUuid);
    }

    public List<JobDispatch> getJobDispatches() {
        ArrayList<JobDispatch> list = new ArrayList<JobDispatch>(this.getChildCount());
        for (AbstractJobComponent child : this.getChildren()) {
            list.add((JobDispatch)child);
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", jobInfo=").append(this.jobInfo);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDisplayName() {
        return this.jobInfo != null ? this.jobInfo.getJobName() : "" + this.uuid;
    }
}

