/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jppf.client.monitoring.AbstractRefreshHandler;
import org.jppf.client.monitoring.jobs.Job;
import org.jppf.client.monitoring.jobs.JobDispatch;
import org.jppf.client.monitoring.jobs.JobDriver;
import org.jppf.client.monitoring.jobs.JobMonitor;
import org.jppf.client.monitoring.jobs.JobMonitoringHandler;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.job.JobInformation;
import org.jppf.job.JobSelector;
import org.jppf.server.job.management.DriverJobManagementMBean;
import org.jppf.server.job.management.NodeJobInformation;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobPollingHandler
extends AbstractRefreshHandler
implements JobMonitoringHandler {
    private static Logger log = LoggerFactory.getLogger(JobPollingHandler.class);
    private final JobMonitor monitor;

    JobPollingHandler(JobMonitor jobMonitor, String name, long refreshInterval) {
        super(name, refreshInterval);
        this.monitor = jobMonitor;
        this.startRefreshTimer();
    }

    @Override
    protected void performRefresh() {
        try {
            for (JobDriver jobDriver : this.monitor.getJobDrivers()) {
                DriverJobManagementMBean proxy = jobDriver.getJobManager();
                if (proxy == null) continue;
                try {
                    JobInformation[] jobInfos = proxy.getJobInformation(JobSelector.ALL_JOBS);
                    Map nodeJobInfos = proxy.getNodeInformation(JobSelector.ALL_JOBS);
                    this.refreshJobs(jobDriver, jobInfos);
                    for (Map.Entry entry : nodeJobInfos.entrySet()) {
                        Job job = jobDriver.getJob((String)entry.getKey());
                        this.refreshDispatches(jobDriver, job, (NodeJobInformation[])entry.getValue());
                    }
                }
                catch (Exception e) {
                    log.error("error getting jobs information for driver {} : {}", (Object)jobDriver, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void refreshJobs(JobDriver jobDriver, JobInformation[] jobInfos) throws Exception {
        List<Job> monitorJobs = jobDriver.getJobs();
        HashMap<String, JobInformation> jobInfoMap = new HashMap<String, JobInformation>();
        for (JobInformation info : jobInfos) {
            jobInfoMap.put(info.getJobUuid(), info);
        }
        HashSet driverUuids = new HashSet(jobInfoMap.keySet());
        ArrayList<String> monitorUuids = new ArrayList<String>(monitorJobs.size());
        for (Job job : monitorJobs) {
            monitorUuids.add(job.getUuid());
        }
        ArrayList<Object> toHandle = new ArrayList(monitorUuids);
        toHandle.removeAll(driverUuids);
        for (String string : toHandle) {
            this.monitor.jobRemoved(jobDriver, jobDriver.getJob(string));
        }
        toHandle = new ArrayList(driverUuids);
        toHandle.removeAll(monitorUuids);
        for (String string : toHandle) {
            this.monitor.jobAdded(jobDriver, new Job((JobInformation)jobInfoMap.get(string)));
        }
        toHandle = new ArrayList(monitorUuids);
        toHandle.retainAll(driverUuids);
        for (String string : toHandle) {
            JobInformation newInfo;
            JobInformation oldInfo = jobDriver.getJob(string).getJobInformation();
            if (!this.monitor.isJobUpdated(oldInfo, newInfo = (JobInformation)jobInfoMap.get(string))) continue;
            Job job = jobDriver.getJob(string);
            job.setJobInformation(newInfo);
            this.monitor.jobUpdated(jobDriver, job);
        }
    }

    private void refreshDispatches(JobDriver jobDriver, Job job, NodeJobInformation[] nodeInfos) throws Exception {
        if (job == null) {
            return;
        }
        List<JobDispatch> monitorDispatches = job.getJobDispatches();
        HashMap<String, NodeJobInformation> nodeJobInfoMap = new HashMap<String, NodeJobInformation>();
        for (NodeJobInformation nji : nodeInfos) {
            nodeJobInfoMap.put(nji.getNodeInfo().getUuid(), nji);
        }
        HashSet driverUuids = new HashSet(nodeJobInfoMap.keySet());
        ArrayList<String> monitorUuids = new ArrayList<String>(monitorDispatches.size());
        for (JobDispatch dispatch : monitorDispatches) {
            monitorUuids.add(dispatch.getUuid());
        }
        ArrayList<Object> toHandle = new ArrayList(monitorUuids);
        toHandle.removeAll(driverUuids);
        for (String string : toHandle) {
            this.monitor.dispatchRemoved(jobDriver, job, job.getJobDispatch(string));
        }
        toHandle = new ArrayList(driverUuids);
        toHandle.removeAll(monitorUuids);
        for (String string : toHandle) {
            NodeJobInformation nji = (NodeJobInformation)nodeJobInfoMap.get(string);
            TopologyNode node = this.monitor.getTopologyManager().getNode(string);
            if (node == null) continue;
            this.monitor.dispatchAdded(jobDriver, job, new JobDispatch(nji.getJobInformation(), node));
        }
    }

    @Override
    public void close() {
        this.stopRefreshTimer();
    }
}

