/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.monitoring.topology.AbstractTopologyComponent;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.client.monitoring.topology.TopologyPeer;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.diagnostics.DiagnosticsMBean;
import org.jppf.management.forwarding.NodeForwardingMBean;
import org.jppf.server.job.management.DriverJobManagementMBean;

public class TopologyDriver
extends AbstractTopologyComponent {
    private static final long serialVersionUID = 1L;
    private final transient JPPFClientConnection connection;

    TopologyDriver(JPPFClientConnection connection) {
        super(connection.getDriverUuid());
        this.connection = connection;
        JPPFConnectionPool pool = connection.getConnectionPool();
        this.managementInfo = new JPPFManagementInfo(pool.getDriverHost(), pool.getDriverIPAddress(), pool.getJmxPort(), pool.getDriverUuid(), 0, pool.isSslEnabled());
    }

    @Override
    public boolean isDriver() {
        return true;
    }

    public JMXDriverConnectionWrapper getJmx() {
        return this.connection == null ? null : this.connection.getConnectionPool().getJmxConnection();
    }

    public JPPFClientConnection getConnection() {
        return this.connection;
    }

    public NodeForwardingMBean getForwarder() {
        JMXDriverConnectionWrapper jmx = this.getJmx();
        if (jmx != null && jmx.isConnected()) {
            try {
                return jmx.getForwarder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DriverJobManagementMBean getJobManager() {
        JMXDriverConnectionWrapper jmx = this.getJmx();
        if (jmx != null && jmx.isConnected()) {
            try {
                return jmx.getJobManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DiagnosticsMBean getDiagnostics() {
        JMXDriverConnectionWrapper jmx = this.getJmx();
        if (jmx != null && jmx.isConnected()) {
            try {
                return jmx.getDiagnosticsProxy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("connection=").append(this.connection);
        sb.append(", managementInfo=").append(this.managementInfo);
        sb.append(", uuid=").append(this.uuid);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDisplayName() {
        return this.managementInfo.toDisplayString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyNode> getNodes() {
        ArrayList<TopologyNode> nodes = new ArrayList<TopologyNode>(this.getChildCount());
        TopologyDriver topologyDriver = this;
        synchronized (topologyDriver) {
            for (AbstractTopologyComponent comp : this.children.values()) {
                if (!comp.isNode()) continue;
                nodes.add((TopologyNode)comp);
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyPeer> getPeers() {
        ArrayList<TopologyPeer> peers = new ArrayList<TopologyPeer>(this.getChildCount());
        TopologyDriver topologyDriver = this;
        synchronized (topologyDriver) {
            for (AbstractTopologyComponent comp : this.children.values()) {
                if (!comp.isPeer()) continue;
                peers.add((TopologyPeer)comp);
            }
        }
        return peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyNode> getNodesAndPeers() {
        ArrayList<TopologyNode> nodes = new ArrayList<TopologyNode>(this.getChildCount());
        TopologyDriver topologyDriver = this;
        synchronized (topologyDriver) {
            for (AbstractTopologyComponent comp : this.children.values()) {
                nodes.add((TopologyNode)comp);
            }
        }
        return nodes;
    }
}

