/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ConnectionPoolEvent;
import org.jppf.client.event.ConnectionPoolListenerAdapter;
import org.jppf.client.monitoring.AbstractComponent;
import org.jppf.client.monitoring.topology.AbstractTopologyComponent;
import org.jppf.client.monitoring.topology.JVMHealthRefreshHandler;
import org.jppf.client.monitoring.topology.NodeRefreshHandler;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyEvent;
import org.jppf.client.monitoring.topology.TopologyListener;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.client.monitoring.topology.TopologyPeer;
import org.jppf.management.NodeSelector;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.concurrent.JPPFThreadFactory;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManager
extends ConnectionPoolListenerAdapter
implements AutoCloseable {
    static Logger log = LoggerFactory.getLogger(TopologyManager.class);
    static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final Map<String, TopologyDriver> driverMap = new Hashtable<String, TopologyDriver>();
    private final Map<String, TopologyPeer> peerMap = new Hashtable<String, TopologyPeer>();
    private final Map<String, TopologyNode> nodeMap = new Hashtable<String, TopologyNode>();
    private final Map<JPPFClientConnection, ClientConnectionStatusListener> statusListenerMap = new Hashtable<JPPFClientConnection, ClientConnectionStatusListener>();
    private final List<TopologyListener> listeners = new CopyOnWriteArrayList<TopologyListener>();
    private ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new JPPFThreadFactory("TopologyEvents"));
    private final JPPFClient client;
    final NodeRefreshHandler refreshHandler;
    final JVMHealthRefreshHandler jvmHealthRefreshHandler;
    private NodeSelector nodeFilter;

    public TopologyManager(TopologyListener ... listeners) {
        this((JPPFClient)null, listeners);
    }

    public TopologyManager(long topologyRefreshInterval, long jvmHealthRefreshInterval, TopologyListener ... listeners) {
        this(topologyRefreshInterval, jvmHealthRefreshInterval, null, false, listeners);
    }

    public TopologyManager(JPPFClient client, TopologyListener ... listeners) {
        this(client == null ? -1L : (Long)client.getConfig().get(JPPFProperties.ADMIN_REFRESH_INTERVAL_TOPOLOGY), client == null ? -1L : (Long)client.getConfig().get(JPPFProperties.ADMIN_REFRESH_INTERVAL_HEALTH), client, false, listeners);
    }

    public TopologyManager(long topologyRefreshInterval, long jvmHealthRefreshInterval, JPPFClient client, TopologyListener ... listeners) {
        this(topologyRefreshInterval, jvmHealthRefreshInterval, client, false, listeners);
    }

    public TopologyManager(long topologyRefreshInterval, long jvmHealthRefreshInterval, JPPFClient client, boolean loadSystemInfo, TopologyListener ... listeners) {
        long n1 = 0L;
        long n2 = 0L;
        if (client == null) {
            this.client = new JPPFClient(this);
            n1 = (Long)this.client.getConfig().get(JPPFProperties.ADMIN_REFRESH_INTERVAL_TOPOLOGY);
            n2 = (Long)this.client.getConfig().get(JPPFProperties.ADMIN_REFRESH_INTERVAL_HEALTH);
        } else {
            this.client = client;
            n1 = topologyRefreshInterval;
            n2 = jvmHealthRefreshInterval;
        }
        this.refreshHandler = new NodeRefreshHandler(this, n1, loadSystemInfo);
        this.jvmHealthRefreshHandler = new JVMHealthRefreshHandler(this, n2);
        if (client != null) {
            client.addConnectionPoolListener(this);
        }
        if (listeners != null) {
            for (TopologyListener listener : listeners) {
                this.addTopologyListener(listener);
            }
        }
        this.init();
    }

    private void init() {
        for (JPPFConnectionPool pool : this.client.getConnectionPools()) {
            List<JPPFClientConnection> list = pool.getConnections(JPPFClientConnectionStatus.ACTIVE, JPPFClientConnectionStatus.EXECUTING);
            if (list.isEmpty()) {
                list = pool.getConnections();
            }
            if (list.isEmpty()) continue;
            JPPFClientConnection c = list.get(0);
            this.connectionAdded(new ConnectionPoolEvent(pool, c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyDriver> getDrivers() {
        Map<String, TopologyDriver> map = this.driverMap;
        synchronized (map) {
            return new ArrayList<TopologyDriver>(this.driverMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyDriver getDriver(String uuid) {
        Map<String, TopologyDriver> map = this.driverMap;
        synchronized (map) {
            return this.driverMap.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyNode> getNodes() {
        Map<String, TopologyNode> map = this.nodeMap;
        synchronized (map) {
            return new ArrayList<TopologyNode>(this.nodeMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyNode> getSlaveNodes(String masterNodeUuid) {
        ArrayList<TopologyNode> result = new ArrayList<TopologyNode>(this.getNodeCount());
        if (masterNodeUuid != null) {
            Map<String, TopologyNode> map = this.nodeMap;
            synchronized (map) {
                for (Map.Entry<String, TopologyNode> entry : this.nodeMap.entrySet()) {
                    TopologyNode node = entry.getValue();
                    String uuid = node.getMasterUuid();
                    if (uuid == null || !uuid.equals(masterNodeUuid)) continue;
                    result.add(node);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyNode getNode(String uuid) {
        Map<String, TopologyNode> map = this.nodeMap;
        synchronized (map) {
            return this.nodeMap.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopologyPeer> getPeers() {
        Map<String, TopologyPeer> map = this.peerMap;
        synchronized (map) {
            return new ArrayList<TopologyPeer>(this.peerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyPeer getPeer(String uuid) {
        Map<String, TopologyPeer> map = this.peerMap;
        synchronized (map) {
            return this.peerMap.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDriverCount() {
        Map<String, TopologyDriver> map = this.driverMap;
        synchronized (map) {
            return this.driverMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount() {
        Map<String, TopologyNode> map = this.nodeMap;
        synchronized (map) {
            return this.nodeMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPeerCount() {
        Map<String, TopologyPeer> map = this.peerMap;
        synchronized (map) {
            return this.peerMap.size();
        }
    }

    public TopologyNode getNodeOrPeer(String uuid) {
        TopologyNode node = this.getNode(uuid);
        if (node == null) {
            node = this.getPeer(uuid);
        }
        return node;
    }

    @Override
    public void connectionAdded(ConnectionPoolEvent event) {
        JPPFClientConnection c = event.getConnection();
        StatusListener listener = new StatusListener();
        if (c.getStatus().isWorkingStatus()) {
            TopologyDriver driver = new TopologyDriver(c);
            if (debugEnabled) {
                log.debug("before adding driver {}", (Object)driver);
            }
            this.driverAdded(driver);
        }
        this.statusListenerMap.put(c, listener);
        c.addClientConnectionStatusListener(listener);
    }

    @Override
    public void connectionRemoved(ConnectionPoolEvent event) {
        StatusListener listener;
        TopologyDriver driver;
        JPPFClientConnection c = event.getConnection();
        String uuid = c.getDriverUuid();
        if (uuid != null && (driver = this.driverMap.remove(uuid)) != null) {
            this.driverRemoved(driver);
        }
        if ((listener = (StatusListener)this.statusListenerMap.remove(c)) != null) {
            c.removeClientConnectionStatusListener(listener);
        }
    }

    public void addTopologyListener(TopologyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("cannot add a null listener");
        }
        this.listeners.add(listener);
    }

    public void removeTopologyListener(TopologyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("cannot remove a null listener");
        }
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driverAdded(TopologyDriver driver) {
        if (debugEnabled) {
            log.debug("adding driver {}, uuid={}", (Object)driver, (Object)driver.getUuid());
        }
        TopologyDriver other = null;
        Map<String, TopologyDriver> map = this.driverMap;
        synchronized (map) {
            other = this.driverMap.get(driver.getUuid());
            if (debugEnabled && other != null) {
                log.debug("driver already exists with same uuid: {}", (Object)other);
            }
            if (other == null) {
                other = this.driverMap.get(driver.getManagementInfo().toDisplayString());
                if (debugEnabled && other != null) {
                    log.debug("driver already exists with same jmx id: {}", (Object)other);
                }
            }
        }
        if (other != null) {
            this.driverRemoved(other);
        }
        map = this.driverMap;
        synchronized (map) {
            this.driverMap.put(driver.getUuid(), driver);
        }
        TopologyEvent event = new TopologyEvent(this, driver, null, TopologyEvent.UpdateType.TOPOLOGY);
        this.dispatchEvent(event, TopologyEvent.Type.DRIVER_ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driverRemoved(TopologyDriver driver) {
        JPPFClientConnection c;
        ClientConnectionStatusListener listener;
        if (debugEnabled) {
            log.debug("removing driver {}", (Object)driver);
        }
        if ((listener = this.statusListenerMap.remove(c = driver.getConnection())) != null) {
            c.removeClientConnectionStatusListener(listener);
        }
        for (AbstractTopologyComponent child : driver.getChildren()) {
            this.nodeRemoved(driver, (TopologyNode)child);
        }
        Map<String, TopologyDriver> map = this.driverMap;
        synchronized (map) {
            this.driverMap.remove(driver.getUuid());
        }
        TopologyEvent event = new TopologyEvent(this, driver, null, TopologyEvent.UpdateType.TOPOLOGY);
        this.dispatchEvent(event, TopologyEvent.Type.DRIVER_REMOVED);
    }

    void driverUpdated(TopologyDriver driver, TopologyEvent.UpdateType updateType) {
        TopologyEvent event = new TopologyEvent(this, driver, null, updateType);
        this.dispatchEvent(event, TopologyEvent.Type.DRIVER_UPDATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nodeAdded(TopologyDriver driver, TopologyNode node) {
        Map<String, TopologyPeer> other;
        if (debugEnabled) {
            log.debug("adding {} {} to driver {}", new Object[]{node.isPeer() ? "peer" : "node", node, driver});
        }
        if (node.isNode() && (other = this.getNodeOrPeer(node.getUuid())) != null) {
            this.nodeRemoved((TopologyDriver)((AbstractComponent)((Object)other)).getParent(), (TopologyNode)((Object)other));
        }
        driver.add(node);
        if (node.isNode()) {
            other = this.nodeMap;
            synchronized (other) {
                this.nodeMap.put(node.getUuid(), node);
            }
        }
        other = this.peerMap;
        synchronized (other) {
            this.peerMap.put(node.getUuid(), (TopologyPeer)node);
        }
        TopologyEvent event = new TopologyEvent(this, driver, node, TopologyEvent.UpdateType.TOPOLOGY);
        this.dispatchEvent(event, TopologyEvent.Type.NODE_ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nodeRemoved(TopologyDriver driver, TopologyNode node) {
        Map<String, TopologyNode> map;
        if (debugEnabled) {
            log.debug("removing {} {} from driver {}", new Object[]{node.isNode() ? "node" : "peer", node, driver});
        }
        driver.remove(node);
        if (node.isNode()) {
            map = this.nodeMap;
            synchronized (map) {
                this.nodeMap.remove(node.getUuid());
            }
        }
        map = this.peerMap;
        synchronized (map) {
            this.peerMap.remove(node.getUuid());
        }
        TopologyEvent event = new TopologyEvent(this, driver, node, TopologyEvent.UpdateType.TOPOLOGY);
        this.dispatchEvent(event, TopologyEvent.Type.NODE_REMOVED);
    }

    void nodeUpdated(TopologyDriver driverData, TopologyNode node, TopologyEvent.UpdateType updateType) {
        TopologyEvent event = new TopologyEvent(this, driverData, node, updateType);
        this.dispatchEvent(event, TopologyEvent.Type.NODE_UPDATED);
    }

    private void dispatchEvent(TopologyEvent event, TopologyEvent.Type type) {
        Runnable dispatchTask = () -> {
            if (log.isTraceEnabled()) {
                log.trace("dispatching event type={} : {}", (Object)type, (Object)event);
            }
            switch (type) {
                case DRIVER_ADDED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.driverAdded(event);
                    }
                    break;
                }
                case DRIVER_REMOVED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.driverRemoved(event);
                    }
                    break;
                }
                case DRIVER_UPDATED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.driverUpdated(event);
                    }
                    break;
                }
                case NODE_ADDED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.nodeAdded(event);
                    }
                    break;
                }
                case NODE_REMOVED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.nodeRemoved(event);
                    }
                    break;
                }
                case NODE_UPDATED: {
                    for (TopologyListener listener : this.listeners) {
                        listener.nodeUpdated(event);
                    }
                    break;
                }
            }
        };
        this.executor.execute(dispatchTask);
    }

    public JPPFClient getJPPFClient() {
        return this.client;
    }

    public synchronized NodeSelector getNodeFilter() {
        return this.nodeFilter;
    }

    public synchronized void setNodeFilter(NodeSelector nodeFilter) {
        this.nodeFilter = nodeFilter;
    }

    @Override
    public void close() {
        this.refreshHandler.stopRefreshTimer();
        this.jvmHealthRefreshHandler.stopRefreshTimer();
        this.listeners.clear();
        this.client.removeConnectionPoolListener(this);
    }

    private class StatusListener
    implements ClientConnectionStatusListener {
        private StatusListener() {
        }

        @Override
        public void statusChanged(ClientConnectionStatusEvent event) {
            TopologyDriver driver;
            JPPFClientConnection c = event.getClientConnection();
            JPPFClientConnectionStatus newStatus = c.getStatus();
            JPPFClientConnectionStatus oldStatus = event.getOldStatus();
            if (newStatus.isWorkingStatus() && !oldStatus.isWorkingStatus()) {
                TopologyDriver driver2 = new TopologyDriver(c);
                if (debugEnabled) {
                    log.debug("before adding driver {}", (Object)driver2);
                }
                TopologyManager.this.driverAdded(driver2);
            } else if (!newStatus.isWorkingStatus() && c.getDriverUuid() != null && (driver = TopologyManager.this.getDriver(c.getDriverUuid())) != null) {
                if (oldStatus.isWorkingStatus()) {
                    for (AbstractTopologyComponent child : driver.getChildren()) {
                        TopologyManager.this.nodeRemoved(driver, (TopologyNode)child);
                    }
                }
                if (newStatus.isTerminatedStatus() && !oldStatus.isTerminatedStatus()) {
                    TopologyManager.this.driverRemoved(driver);
                }
            }
        }
    }
}

