/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import org.jppf.client.monitoring.topology.AbstractTopologyComponent;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyNodeStatus;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFNodeState;
import org.jppf.management.NodePendingAction;

public class TopologyNode
extends AbstractTopologyComponent {
    private static final long serialVersionUID = 1L;
    private static final JPPFNodeState EMPTY_STATE = new JPPFNodeState();
    private transient JPPFNodeState nodeState;
    private int nbSlaveNodes = -1;
    private TopologyNodeStatus status = TopologyNodeStatus.UP;

    public TopologyNode(JPPFManagementInfo nodeInformation) {
        this(nodeInformation, EMPTY_STATE);
    }

    TopologyNode(JPPFManagementInfo nodeInformation, JPPFNodeState nodeState) {
        super(nodeInformation.getUuid());
        this.managementInfo = nodeInformation;
        this.nodeState = nodeState;
    }

    TopologyNode(String uuid) {
        super(uuid);
        this.managementInfo = null;
        this.nodeState = EMPTY_STATE;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    public JPPFNodeState getNodeState() {
        return this.nodeState;
    }

    public void refreshNodeState(JPPFNodeState newState) {
        this.nodeState = newState;
        this.setStatus(this.nodeState == null ? TopologyNodeStatus.DOWN : TopologyNodeStatus.UP);
    }

    public TopologyNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(TopologyNodeStatus status) {
        if (status == TopologyNodeStatus.DOWN) {
            this.status = status;
        }
    }

    public int getNbSlaveNodes() {
        return this.nbSlaveNodes;
    }

    public void setNbSlaveNodes(int nbSlaveNodes) {
        this.nbSlaveNodes = nbSlaveNodes;
    }

    public String getMasterUuid() {
        return this.managementInfo == null ? null : this.managementInfo.getMasterUuid();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("managementInfo=").append(this.managementInfo);
        sb.append(", uuid=").append(this.uuid);
        sb.append(", nodeState=").append(this.nodeState);
        sb.append(']');
        return sb.toString();
    }

    public NodePendingAction getPendingAction() {
        return this.nodeState == null ? null : this.nodeState.getPendingAction();
    }

    public TopologyDriver getDriver() {
        return this.isNode() ? (TopologyDriver)this.getParent() : null;
    }

    @Override
    public String getDisplayName() {
        return this.managementInfo != null ? this.managementInfo.toDisplayString() : this.toString();
    }
}

