/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.management.Notification;
import org.jppf.jmx.JMXHelper;
import org.jppf.jmxremote.message.AbstractJMXMessage;

public class JMXNotification
extends AbstractJMXMessage {
    private static final long serialVersionUID = 1L;
    private static final Integer[] NO_LISTENER = new Integer[0];
    private Notification notification;
    private Integer[] listenerIDs;

    public JMXNotification(long messageID, Notification notification, Integer[] listenerIDs) {
        super(messageID, (byte)28);
        this.notification = notification;
        this.listenerIDs = listenerIDs == null ? NO_LISTENER : listenerIDs;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public Integer[] getListenerIDs() {
        return this.listenerIDs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "messageID=" + this.getMessageID() + ", messageType=" + JMXHelper.name((byte)this.getMessageType()) + ", listenerIDs=" + Arrays.toString((Object[])this.listenerIDs) + ", notification=" + this.notification + ']';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.notification);
        out.writeInt(this.listenerIDs.length);
        Integer[] integerArray = this.listenerIDs;
        int n = this.listenerIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = integerArray[n2];
            out.writeInt(id);
            ++n2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.notification = (Notification)in.readObject();
        int n = in.readInt();
        if (n == 0) {
            this.listenerIDs = NO_LISTENER;
        } else {
            this.listenerIDs = new Integer[n];
            int i = 0;
            while (i < n) {
                this.listenerIDs[i] = in.readInt();
                ++i;
            }
        }
    }
}

