/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.jmx.JMXEnvHelper;
import org.jppf.jmx.JPPFJMXProperties;
import org.jppf.jmxremote.message.JMXMessage;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.nio.MessageWrapper;
import org.jppf.nio.AbstractNioContext;
import org.jppf.nio.NioContext;
import org.jppf.nio.NioMessage;
import org.jppf.nio.SimpleNioMessage;
import org.jppf.utils.concurrent.QueueHandler;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXContext
extends AbstractNioContext {
    private static Logger log = LoggerFactory.getLogger(JMXContext.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private MessageWrapper currentMessageWrapper;
    private final QueueHandler<MessageWrapper> pendingJmxMessages;
    private final JMXNioServer server;
    private JMXMessageHandler messageHandler;
    private SelectionKey selectionKey;
    private static final AtomicInteger idSequence = new AtomicInteger(0);
    private final int id = idSequence.incrementAndGet();

    public JMXContext(JMXNioServer server, boolean reading, SocketChannel socketChannel, Map<String, ?> env) {
        this.server = server;
        if (reading) {
            this.pendingJmxMessages = null;
        } else {
            int size = JMXEnvHelper.getInt((JPPFProperty)JPPFJMXProperties.NOTIF_QUEUE_SIZE, env, null);
            if (size <= 0) {
                size = (Integer)JPPFJMXProperties.NOTIF_QUEUE_SIZE.getDefaultValue();
            }
            this.pendingJmxMessages = QueueHandler.builder().withCapacity(size).handlingPeakSizeAs(server::updatePeakPendingMessages).build();
        }
        this.peer = false;
        this.socketChannel = socketChannel;
    }

    public void handleException(Exception exception) {
        try {
            this.server.closeConnection(this.getChannels(), exception, false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getConnectionID() {
        return this.messageHandler.getChannels().getConnectionID();
    }

    public JMXMessage deserializeMessage(SimpleNioMessage message) throws Exception {
        return message != null ? (JMXMessage)IOHelper.unwrappedData((DataLocation)message.getCurrentDataLocation()) : null;
    }

    public void offerJmxMessage(JMXMessage jmxMessage) throws Exception {
        SimpleNioMessage msg = new SimpleNioMessage((NioContext)this);
        msg.setCurrentDataLocation(IOHelper.serializeData((Object)jmxMessage));
        this.pendingJmxMessages.put((Object)new MessageWrapper(jmxMessage, (NioMessage)msg));
    }

    public MessageWrapper pollJmxMessage() {
        MessageWrapper msg = (MessageWrapper)this.pendingJmxMessages.poll();
        return msg;
    }

    public boolean hasQueuedMessage() {
        return !this.pendingJmxMessages.isEmpty();
    }

    public JMXMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public ChannelsPair getChannels() {
        return this.messageHandler.getChannels();
    }

    public void setMessageHandler(JMXMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("id=").append(this.id);
        sb.append(", connectionID=").append(this.messageHandler == null ? "null" : this.getConnectionID());
        sb.append(", serverSide=").append(this.messageHandler == null ? "null" : Boolean.valueOf(this.getChannels().isServerSide()));
        sb.append(", ssl=").append(this.ssl);
        if (this.pendingJmxMessages != null) {
            sb.append(", pendingMessages=").append(this.pendingJmxMessages.size());
        }
        sb.append(", socketChannel=").append(this.socketChannel);
        return sb.append(']').toString();
    }

    public JMXNioServer getServer() {
        return this.server;
    }

    public SelectionKey getSelectionKey() {
        if (this.selectionKey == null) {
            this.selectionKey = this.socketChannel.keyFor(this.server.getSelector());
        }
        return this.selectionKey;
    }

    public boolean readMessage() throws Exception {
        if (this.readMessage == null) {
            this.readMessage = new SimpleNioMessage((NioContext)this);
        }
        this.readByteCount = this.readMessage.getChannelReadCount();
        boolean b = false;
        try {
            b = this.readMessage.read();
        }
        catch (Exception e) {
            this.updateTrafficStats();
            throw e;
        }
        this.readByteCount = this.readMessage.getChannelReadCount() - this.readByteCount;
        if (debugEnabled) {
            log.debug("read {} bytes", (Object)this.readByteCount);
        }
        if (b) {
            this.updateTrafficStats();
        }
        return b;
    }

    public boolean writeMessage() throws Exception {
        this.readByteCount = this.readMessage.getChannelWriteCount();
        boolean b = false;
        try {
            b = this.readMessage.write();
        }
        catch (Exception e) {
            this.updateTrafficStats();
            throw e;
        }
        this.readByteCount = this.readMessage.getChannelWriteCount() - this.readByteCount;
        if (debugEnabled) {
            log.debug("wrote {} bytes", (Object)this.readByteCount);
        }
        if (b) {
            this.updateTrafficStats();
        }
        return b;
    }

    private void updateTrafficStats() {
        if (this.readMessage != null && this.server.getStats() != null) {
            double value;
            if (this.inSnapshot == null) {
                this.inSnapshot = this.server.getStats().getSnapshot("jmx.traffic.in");
            }
            if (this.outSnapshot == null) {
                this.outSnapshot = this.server.getStats().getSnapshot("jmx.traffic.out");
            }
            if ((value = (double)this.readMessage.getChannelReadCount()) > 0.0) {
                this.inSnapshot.addValues(value, 1L);
            }
            if ((value = (double)this.readMessage.getChannelWriteCount()) > 0.0) {
                this.outSnapshot.addValues(value, 1L);
            }
        }
    }

    MessageWrapper getCurrentMessageWrapper() {
        return this.currentMessageWrapper;
    }

    void setCurrentMessageWrapper(MessageWrapper currentMessageWrapper) {
        this.currentMessageWrapper = currentMessageWrapper;
    }

    public int getId() {
        return this.id;
    }
}

