/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.notification;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.notification.MBeanServerNotificationDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNotificationHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerNotificationHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final AtomicInteger listenerSequence = new AtomicInteger(0);
    private final Map<MBeanServer, MBeanServerNotificationDispatcher> mbeanServerMap = new HashMap<MBeanServer, MBeanServerNotificationDispatcher>();
    private final JMXNioServer server;

    public ServerNotificationHandler(JMXNioServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNotificationListener(MBeanServer mbeanServer, String connectionID, ObjectName mbeanName, NotificationFilter filter) throws Exception {
        MBeanServerNotificationDispatcher dispatcher = null;
        Map<MBeanServer, MBeanServerNotificationDispatcher> map = this.mbeanServerMap;
        synchronized (map) {
            dispatcher = this.mbeanServerMap.get(mbeanServer);
            if (dispatcher == null) {
                if (debugEnabled) {
                    log.debug("creating notification dispatcher");
                }
                dispatcher = new MBeanServerNotificationDispatcher(mbeanServer, this.server);
                this.mbeanServerMap.put(mbeanServer, dispatcher);
            }
        }
        int listenerID = this.listenerSequence.incrementAndGet();
        if (debugEnabled) {
            log.debug("creating listener with listenerID = {}", (Object)listenerID);
        }
        dispatcher.addNotificationListener(mbeanName, filter, listenerID, connectionID);
        return listenerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListeners(MBeanServer mbeanServer, ObjectName mbeanName, int[] listenerIDs) throws Exception {
        MBeanServerNotificationDispatcher dispatcher = null;
        Map<MBeanServer, MBeanServerNotificationDispatcher> map = this.mbeanServerMap;
        synchronized (map) {
            dispatcher = this.mbeanServerMap.get(mbeanServer);
        }
        if (dispatcher == null) {
            throw new ListenerNotFoundException("found no listener for " + mbeanName);
        }
        if (debugEnabled) {
            log.debug("removing listeners with listenerIDs = {}", (Object)Arrays.toString(listenerIDs));
        }
        dispatcher.removeNotificationListeners(mbeanName, listenerIDs);
    }
}

