/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.job.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.job.AllJobsSelector;
import org.jppf.job.JobSelector;
import org.jppf.job.JobUuidSelector;
import org.jppf.job.persistence.PersistedJobsManagerMBean;
import org.jppf.job.persistence.PersistenceInfo;
import org.jppf.job.persistence.PersistenceInfoImpl;
import org.jppf.job.persistence.PersistenceObjectType;
import org.jppf.job.persistence.impl.PersistenceInfoKey;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.JPPFDriver;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.queue.PersistenceHandler;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.streams.JPPFByteArrayOutputStream;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedJobsManager
implements PersistedJobsManagerMBean {
    private static Logger log = LoggerFactory.getLogger(PersistedJobsManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private final PersistenceHandler handler;
    private final Map<Long, Map<PersistenceInfoKey, DataLocation>> loadRequests = new ConcurrentHashMap<Long, Map<PersistenceInfoKey, DataLocation>>();
    private final AtomicLong loadRequestSequence = new AtomicLong(0L);

    public PersistedJobsManager(JPPFDriver driver) {
        this.handler = driver.getQueue().getPersistenceHandler();
    }

    public List<String> getPersistedJobUuids(JobSelector selector) throws Exception {
        return this.getMatchingUuids(selector);
    }

    public Object getPersistedJobObject(String uuid, PersistenceObjectType type, int position) throws Exception {
        if (debugEnabled) {
            log.debug("requesting object with uuid={}, type={}, pos={}", new Object[]{uuid, type, position});
        }
        DataLocation data = this.handler.load((PersistenceInfo)new PersistenceInfoImpl(uuid, null, type, position, null));
        if (debugEnabled) {
            if (data != null) {
                log.debug("got object={} for uuid={}, type={}, pos={}", new Object[]{data, uuid, type, position});
            } else {
                log.debug("could not find persisted object for uuid={}, type={}, pos={}", new Object[]{uuid, type, position});
            }
        }
        return PersistedJobsManager.deserialize(data, type);
    }

    public int[][] getPersistedJobPositions(String uuid) throws Exception {
        return this.handler.getPersistedJobPositions(uuid);
    }

    public List<String> deletePersistedJobs(JobSelector selector) throws Exception {
        List<String> persisted = this.getMatchingUuids(selector);
        ArrayList<String> result = new ArrayList<String>();
        for (String uuid : persisted) {
            try {
                this.handler.deleteJob(uuid);
                result.add(uuid);
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug("error deleting job with uuid={} : {}", (Object)uuid, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    continue;
                }
                log.warn("error deleting job with uuid={} : {}", (Object)uuid, (Object)ExceptionUtils.getMessage((Throwable)e));
            }
        }
        if (debugEnabled) {
            log.debug("request to delete jobs matching {}, result = {}", (Object)selector, result);
        }
        return result;
    }

    public boolean isJobersisted(String uuid) throws Exception {
        return this.handler.isJobPersisted(uuid);
    }

    public boolean isJobComplete(String uuid) throws Exception {
        TaskBundle header = this.handler.loadHeader(uuid);
        if (header == null) {
            return false;
        }
        int n = header.getTaskCount();
        int[][] positions = this.getPersistedJobPositions(uuid);
        if (positions == null || positions.length < 2) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (positions[i] == null || positions[i].length == 0 || positions[i].length < n) {
                return false;
            }
            Arrays.sort(positions[i]);
        }
        return Arrays.equals(positions[0], positions[1]);
    }

    private List<String> getMatchingUuids(JobSelector selector) throws Exception {
        JobSelector sel = selector == null ? JobSelector.ALL_JOBS : selector;
        List<String> uuids = this.handler.getPersistedJobUuids();
        ArrayList<String> result = new ArrayList<String>(uuids.size());
        for (String uuid : uuids) {
            if (sel instanceof AllJobsSelector || sel instanceof JobUuidSelector && ((JobUuidSelector)sel).getUuids().contains(uuid)) {
                result.add(uuid);
                continue;
            }
            DataLocation headerData = this.handler.load((PersistenceInfo)new PersistenceInfoImpl(uuid, null, PersistenceObjectType.JOB_HEADER, -1, null));
            TaskBundle header = (TaskBundle)IOHelper.unwrappedData((DataLocation)headerData);
            if (!sel.accepts((JPPFDistributedJob)header)) continue;
            result.add(uuid);
        }
        if (debugEnabled) {
            log.debug("uuids matching {} : {}", (Object)sel, result);
        }
        return result;
    }

    public long requestLoad(Collection<PersistenceInfo> infos) throws Exception {
        long id = this.loadRequestSequence.incrementAndGet();
        List<DataLocation> list = this.handler.load(infos);
        HashMap<PersistenceInfoKey, DataLocation> map = new HashMap<PersistenceInfoKey, DataLocation>(list.size());
        int i = 0;
        for (PersistenceInfo info : infos) {
            map.put(new PersistenceInfoKey(info), list.get(i++));
        }
        this.loadRequests.put(id, map);
        return id;
    }

    public Object getPersistedJobObject(long requestId, String uuid, PersistenceObjectType type, int position) throws Exception {
        Map<PersistenceInfoKey, DataLocation> map;
        if (debugEnabled) {
            log.debug("requesting object with uuid={}, type={}, pos={}, requestId={}", new Object[]{uuid, type, position, requestId});
        }
        if ((map = this.loadRequests.get(requestId)) == null) {
            return null;
        }
        PersistenceInfoKey key = new PersistenceInfoKey(uuid, type, position);
        DataLocation data = map.remove(key);
        if (map.isEmpty()) {
            this.loadRequests.remove(requestId);
        }
        if (traceEnabled) {
            if (data != null) {
                log.trace(String.format("got object=%s for uuid=%s, type=%s, pos=%d, requestId=%d", data, uuid, type, position, requestId));
            } else {
                log.trace(String.format("could not find persisted object for uuid=%s, type=%s, pos=%d, requestId=%d", uuid, type, position, requestId));
            }
        }
        return PersistedJobsManager.deserialize(data, type);
    }

    private static Object deserialize(DataLocation data, PersistenceObjectType type) throws Exception {
        if (data == null) {
            return null;
        }
        DataLocation dl = data;
        if (type == PersistenceObjectType.TASK) {
            ServerTask task = (ServerTask)IOHelper.unwrappedData((DataLocation)data);
            dl = task.getInitialTask();
        }
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream(dl.getSize());
        long l = StreamUtils.copyStream((InputStream)dl.getInputStream(), (OutputStream)baos, (boolean)true);
        if (debugEnabled) {
            log.debug("copied {} bytes", (Object)l);
        }
        return baos.toByteArray();
    }

    public boolean deleteLoadRequest(long requestId) throws Exception {
        if (debugEnabled) {
            log.debug("deleting load request with id={}", (Object)requestId);
        }
        return this.loadRequests.remove(requestId) != null;
    }
}

