/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jppf.load.balancer.LoadBalancingInformation;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.management.JPPFDriverAdminMBean;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodeSelectionHelper;
import org.jppf.management.NodeSelector;
import org.jppf.server.DriverInitializer;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.utils.LocalizationUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.stats.AbstractJPPFSnapshot;
import org.jppf.utils.stats.JPPFSnapshot;
import org.jppf.utils.stats.JPPFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDriverAdmin
implements JPPFDriverAdminMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JPPFDriverAdmin.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final String I18N_BASE = "org.jppf.server.i18n.server_messages";
    private final JPPFDriver driver;
    private LoadBalancingInformation currentLoadBalancingInformation;
    private final Object loadBalancingInformationLock = new Object();
    private final NodeSelectionHelper selectionHelper;

    public JPPFDriverAdmin(JPPFDriver driver) {
        this.driver = driver;
        this.selectionHelper = new NodeSelectionHelper(driver);
    }

    public Integer nbNodes() throws Exception {
        return this.nbNodes(null);
    }

    public Integer nbNodes(NodeSelector selector) throws Exception {
        return this.selectionHelper.getNbChannels(selector == null ? NodeSelector.ALL_NODES : selector, false, false);
    }

    public Collection<JPPFManagementInfo> nodesInformation() {
        return this.nodesInformation(null, false);
    }

    public Collection<JPPFManagementInfo> nodesInformation(NodeSelector selector) {
        return this.nodesInformation(selector, false);
    }

    public Collection<JPPFManagementInfo> nodesInformation(NodeSelector selector, boolean includePeers) {
        try {
            Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector, includePeers, false);
            ArrayList<JPPFManagementInfo> list = new ArrayList<JPPFManagementInfo>(nodes.size());
            for (BaseNodeContext context : nodes) {
                JPPFManagementInfo info = context.getManagementInfo();
                if (info == null) continue;
                list.add(info);
            }
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Integer nbIdleNodes() throws Exception {
        return this.nbIdleNodes(null);
    }

    public Integer nbIdleNodes(NodeSelector selector) throws Exception {
        return this.nbIdleNodes(selector, false);
    }

    public Integer nbIdleNodes(NodeSelector selector, boolean includePeers) throws Exception {
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector, includePeers, false);
        if (nodes == null) {
            return -1;
        }
        int result = 0;
        for (BaseNodeContext node : nodes) {
            boolean idle = node.getIdle().get();
            if (!idle) continue;
            ++result;
        }
        if (debugEnabled) {
            log.debug("there are {} nodes, including {} idle nodes", (Object)nodes.size(), (Object)result);
        }
        return result;
    }

    public Collection<JPPFManagementInfo> idleNodesInformation() throws Exception {
        return this.idleNodesInformation(null);
    }

    public Collection<JPPFManagementInfo> idleNodesInformation(NodeSelector selector) {
        try {
            Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector, false, false);
            ArrayList<JPPFManagementInfo> list = new ArrayList<JPPFManagementInfo>(nodes.size());
            for (BaseNodeContext node : nodes) {
                JPPFManagementInfo info;
                if (!node.getIdle().get() || (info = node.getManagementInfo()) == null) continue;
                list.add(info);
            }
            return list;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JPPFStatistics statistics() throws Exception {
        try {
            JPPFStatistics stats = this.driver.getStatistics();
            if (log.isTraceEnabled()) {
                log.trace("stats request = " + stats);
            }
            return stats;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String changeLoadBalancerSettings(String algorithm, Map<Object, Object> parameters) throws Exception {
        try {
            if (algorithm == null) {
                return "Error: no algorithm specified (null value)";
            }
            JPPFBundlerFactory factory = this.getBundlerFactory();
            if (!factory.getBundlerProviderNames().contains(algorithm)) {
                return "Error: unknown algorithm '" + algorithm + '\'';
            }
            TypedProperties props = new TypedProperties(parameters);
            Object object = this.loadBalancingInformationLock;
            synchronized (object) {
                this.currentLoadBalancingInformation = new LoadBalancingInformation(algorithm, props, this.loadBalancerInformation().getAlgorithmNames());
                factory.setAndGetCurrentInfo(this.currentLoadBalancingInformation);
            }
            return "load.balancing.updated";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Error : " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalancingInformation loadBalancerInformation() throws Exception {
        Object object = this.loadBalancingInformationLock;
        synchronized (object) {
            if (this.currentLoadBalancingInformation == null) {
                this.currentLoadBalancingInformation = this.computeCurrentLoadBalancingInformation();
            }
            return this.currentLoadBalancingInformation;
        }
    }

    private LoadBalancingInformation computeCurrentLoadBalancingInformation() {
        JPPFBundlerFactory factory = this.getBundlerFactory();
        LoadBalancingInformation info = factory.getCurrentInfo();
        List algorithmsList = factory.getBundlerProviderNames();
        return new LoadBalancingInformation(info.getAlgorithm(), info.getParameters(), algorithmsList);
    }

    public String restartShutdown(Long shutdownDelay, Long restartDelay) throws Exception {
        try {
            if (debugEnabled) {
                log.debug("request to restart/shutdown this driver, shutdownDelay=" + shutdownDelay + ", restartDelay=" + restartDelay);
            }
            boolean restart = restartDelay >= 0L;
            this.driver.initiateShutdownRestart(shutdownDelay, restart, restartDelay);
            return JPPFDriverAdmin.localize("request.acknowledged");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Error : " + e.getMessage();
        }
    }

    private static String localize(String message) {
        return LocalizationUtils.getLocalized((String)I18N_BASE, (String)message);
    }

    public void resetStatistics() throws Exception {
        if (debugEnabled) {
            log.debug("statistics reset requested");
        }
        JPPFStatistics stats = this.driver.getStatistics();
        JPPFSnapshot.LabelExcludingFilter filter = new JPPFSnapshot.LabelExcludingFilter(new String[]{"nodes", "idle.nodes", "clients", "job.count", "task.queue.count"});
        stats.reset((JPPFStatistics.Filter)filter);
        for (String s : new String[]{"job.count", "task.queue.count"}) {
            JPPFSnapshot snapshot = stats.getSnapshot(s);
            if (!(snapshot instanceof AbstractJPPFSnapshot)) continue;
            ((AbstractJPPFSnapshot)snapshot).assignLatestToMax();
        }
    }

    public JPPFSystemInformation systemInformation() throws Exception {
        return this.driver.getSystemInformation();
    }

    private JPPFBundlerFactory getBundlerFactory() {
        return this.driver.getAsyncNodeNioServer().getBundlerFactory();
    }

    public void toggleActiveState(NodeSelector selector) throws Exception {
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector);
        for (BaseNodeContext node : nodes) {
            this.driver.getAsyncNodeNioServer().activateNode(node.getUuid(), !node.isActive());
        }
    }

    public Map<String, Boolean> getActiveState(NodeSelector selector) throws Exception {
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(nodes.size());
        for (BaseNodeContext node : nodes) {
            result.put(node.getUuid(), node.isActive());
        }
        return result;
    }

    public void setActiveState(NodeSelector selector, boolean active) throws Exception {
        Set<BaseNodeContext> nodes = this.selectionHelper.getChannels(selector == null ? NodeSelector.ALL_NODES : selector);
        for (BaseNodeContext node : nodes) {
            this.driver.getAsyncNodeNioServer().activateNode(node.getUuid(), active);
        }
    }

    public void setBroadcasting(boolean broadcasting) throws Exception {
        DriverInitializer di = this.driver.getInitializer();
        boolean b = di.isBroadcasting();
        if (b == broadcasting) {
            return;
        }
        if (b) {
            di.initBroadcaster();
        } else {
            di.stopBroadcaster();
        }
    }

    public boolean getBroadcasting() throws Exception {
        return this.driver.getInitializer().isBroadcasting();
    }
}

