/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.Map;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.JPPFReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.DelegationModel;
import org.jppf.execute.ExecutionInfo;
import org.jppf.management.JPPFNodeAdminMBean;
import org.jppf.management.JPPFNodeState;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodePendingAction;
import org.jppf.management.NodeStatusNotifier;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.server.node.JPPFNode;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.ConfigurationOverridesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFNodeAdmin
implements JPPFNodeAdminMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JPPFNodeAdmin.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFNodeState nodeState = new JPPFNodeState();
    transient JPPFNode node = null;

    public JPPFNodeAdmin(JPPFNode node) {
        if (debugEnabled) {
            log.debug("instantiating JPPFNodeAdmin");
        }
        this.node = node;
        node.setNodeAdmin((JPPFNodeAdminMBean)this);
        this.nodeState.setThreadPriority(node.getExecutionManager().getThreadsPriority());
        this.nodeState.setThreadPoolSize(node.getExecutionManager().getThreadPoolSize());
        node.getLifeCycleEventHandler().addProvider((Object)new NodeStatusNotifier(this));
    }

    public JPPFNodeState state() throws Exception {
        JPPFNodeState ns = this.nodeState.copy();
        if (log.isTraceEnabled()) {
            log.trace("nn threads = " + ns.getThreadPoolSize());
        }
        return ns;
    }

    public void updateThreadPoolSize(Integer size) throws Exception {
        if (debugEnabled) {
            log.debug("node request to change thread pool size to " + size);
        }
        this.node.getExecutionManager().setThreadPoolSize(size.intValue());
        this.nodeState.setThreadPoolSize(size.intValue());
    }

    public JPPFSystemInformation systemInformation() throws Exception {
        JPPFSystemInformation info = this.node.getSystemInformation();
        ExecutionInfo nei = this.node.getExecutionManager().getThreadManager().computeExecutionInfo();
        info.getRuntime().setProperty("cpuTime", nei == null ? "-1" : Long.toString(nei.cpuTime / 1000000L));
        return info;
    }

    public void restart() throws Exception {
        this.restart(true);
    }

    public void restart(Boolean interruptIfRunning) throws Exception {
        if (debugEnabled) {
            log.debug("node restart requested with interruptIfRunning={}", (Object)interruptIfRunning);
        }
        boolean interrupt = interruptIfRunning == null ? true : interruptIfRunning;
        this.shutdownOrRestart(interrupt, true);
    }

    public void shutdown() throws Exception {
        this.shutdown(true);
    }

    public void shutdown(Boolean interruptIfRunning) throws Exception {
        if (debugEnabled) {
            log.debug("node shutdown requested with interruptIfRunning={}", (Object)interruptIfRunning);
        }
        boolean interrupt = interruptIfRunning == null ? true : interruptIfRunning;
        this.shutdownOrRestart(interrupt, false);
    }

    private void shutdownOrRestart(boolean interrupt, boolean restart) throws Exception {
        String s = restart ? "restart" : "shutdown";
        String msg = String.format("%s node %s requested", interrupt ? "immediate" : "deferred", s);
        System.out.println(msg);
        log.info(msg);
        if (interrupt || !this.node.isExecuting()) {
            if (this.node.getShuttingDown().compareAndSet(false, true)) {
                if (debugEnabled) {
                    log.debug("scheduling immediate {}", (Object)s);
                }
                Runnable r = () -> {
                    block3: {
                        try {
                            this.node.shutdown(restart);
                        }
                        catch (Error | Exception e) {
                            log.error("error trying to {} the node: ", (Object)s, (Object)e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                            if (!(e instanceof RuntimeException)) break block3;
                            throw (RuntimeException)e;
                        }
                    }
                };
                ThreadUtils.startThread((Runnable)r, (String)("Node " + s));
            }
        } else {
            NodePendingAction action = restart ? NodePendingAction.RESTART : NodePendingAction.SHUTDOWN;
            this.node.setPendingAction(action);
            this.nodeState.setPendingAction(action);
            if (debugEnabled) {
                log.debug("pending action after {} request: {}", (Object)s, (Object)action);
            }
        }
    }

    public void reconnect(Boolean interrupt) throws Exception {
        log.info("{} reconnection requested", (Object)(interrupt != false ? "immediate" : "deferred"));
        if (interrupt.booleanValue() || !this.node.isExecuting()) {
            this.node.setReconnectionNotification((JPPFReconnectionNotification)new JPPFNodeReconnectionNotification("request to reconnect the node", null, ConnectionReason.MANAGEMENT_REQUEST));
            this.node.closeDataChannel();
        } else {
            NodePendingAction action = NodePendingAction.RECONNECT;
            this.node.setPendingAction(action);
            this.nodeState.setPendingAction(action);
            if (debugEnabled) {
                log.debug("pending action after reconnection request: {}", (Object)action);
            }
        }
    }

    public void resetTaskCounter() throws Exception {
        if (debugEnabled) {
            log.debug("node task counter reset requested");
        }
        this.setTaskCounter(0);
    }

    public synchronized void setTaskCounter(Integer n) throws Exception {
        if (debugEnabled) {
            log.debug("node tasks counter reset to " + n + " requested");
        }
        this.node.setExecutedTaskCount(n.intValue());
        this.nodeState.setNbTasksExecuted(n.intValue());
    }

    public void updateThreadsPriority(Integer newPriority) throws Exception {
        if (debugEnabled) {
            log.debug("node threads priority reset to " + newPriority + " requested");
        }
        this.node.getExecutionManager().updateThreadsPriority(newPriority.intValue());
        this.nodeState.setThreadPriority(newPriority.intValue());
    }

    public void updateConfiguration(Map<Object, Object> configOverrides, Boolean restart, Boolean interruptIfRunning) throws Exception {
        if (configOverrides == null) {
            return;
        }
        if (debugEnabled) {
            log.debug("node request to change configuration, restart={}, interruptIfRunning={}, configOverrides={}", new Object[]{restart, interruptIfRunning, configOverrides});
        }
        if (configOverrides.containsKey("jppf.node.uuid")) {
            configOverrides.remove("jppf.node.uuid");
        }
        if (!configOverrides.isEmpty()) {
            TypedProperties overrides = new TypedProperties(configOverrides);
            new ConfigurationOverridesHandler(this.node.getConfiguration()).save(overrides);
            this.node.getConfiguration().putAll((Map)overrides);
            this.node.triggerConfigChanged();
        }
        if (restart.booleanValue()) {
            this.shutdownOrRestart(interruptIfRunning, true);
        }
    }

    public void updateConfiguration(Map<Object, Object> configOverrides, Boolean restart) throws Exception {
        this.updateConfiguration(configOverrides, restart, true);
    }

    public void cancelJob(String jobId, Boolean requeue) throws Exception {
        try {
            if (debugEnabled) {
                log.debug("Request to cancel jobuUid = '{}', requeue = {}", (Object)jobId, (Object)requeue);
            }
            if (jobId == null) {
                return;
            }
            this.node.getExecutionManager().cancelJob(jobId, true, requeue.booleanValue());
        }
        catch (RuntimeException e) {
            log.debug("error cancelling job with uuid={}:", (Object)jobId, (Object)e);
            throw e;
        }
    }

    public DelegationModel getDelegationModel() throws Exception {
        return AbstractJPPFClassLoader.getDelegationModel();
    }

    public void setDelegationModel(DelegationModel model) throws Exception {
        if (model != null) {
            AbstractJPPFClassLoader.setDelegationModel((DelegationModel)model);
        }
    }

    public NodePendingAction pendingAction() {
        if (!this.node.isShutdownRequested()) {
            return NodePendingAction.NONE;
        }
        return this.node.isRestart() ? NodePendingAction.RESTART : NodePendingAction.SHUTDOWN;
    }

    public boolean cancelPendingAction() {
        log.info("cancelPendingAction() requested");
        boolean b = this.node.cancelPendingAction();
        if (b) {
            this.nodeState.setPendingAction(NodePendingAction.NONE);
        }
        return b;
    }

    synchronized JPPFNodeState getNodeState() {
        return this.nodeState;
    }
}

