/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFNodeConnectionNotifierMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPPFNodeConnectionNotifier
extends NotificationBroadcasterSupport
implements JPPFNodeConnectionNotifierMBean {
    private static Logger log = LoggerFactory.getLogger(JPPFNodeConnectionNotifier.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final JPPFNodeConnectionNotifier instance = new JPPFNodeConnectionNotifier();
    private final AtomicLong sequence = new AtomicLong(0L);

    private JPPFNodeConnectionNotifier() {
    }

    public void onNodeConnected(JPPFManagementInfo info) {
        if (debugEnabled) {
            log.debug("sending node connected notification for {}", (Object)info);
        }
        this.notify(info, true);
    }

    public void onNodeDisconnected(JPPFManagementInfo info) {
        if (debugEnabled) {
            log.debug("sending node disconnected notification for {}", (Object)info);
        }
        this.notify(info, false);
    }

    private void notify(JPPFManagementInfo info, boolean connected) {
        Notification notif = new Notification(connected ? "connected" : "disconnected", (Object)"org.jppf:name=nodeConnectionNotifier,type=driver", this.sequence.incrementAndGet(), System.currentTimeMillis());
        notif.setUserData(info);
        this.sendNotification(notif);
    }

    public static JPPFNodeConnectionNotifier getInstance() {
        return instance;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (debugEnabled) {
            log.debug("adding notification listener");
        }
        super.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("removing notification listener");
        }
        super.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("removing notification listener with filter");
        }
        super.removeNotificationListener(listener, filter, handback);
    }
}

