/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jppf.management.JPPFNodeTaskMonitorMBean;
import org.jppf.management.ObjectNameCache;
import org.jppf.management.TaskExecutionNotification;
import org.jppf.management.TaskInformation;
import org.jppf.node.Node;
import org.jppf.node.event.TaskExecutionEvent;
import org.jppf.node.event.TaskExecutionListener;
import org.jppf.utils.concurrent.QueueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFNodeTaskMonitor
extends NotificationBroadcasterSupport
implements JPPFNodeTaskMonitorMBean,
TaskExecutionListener {
    private static Logger log = LoggerFactory.getLogger(JPPFNodeTaskMonitor.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ObjectName OBJECT_NAME;
    private int taskCount;
    private int taskInErrorCount;
    private int taskSuccessfulCount;
    private long totalCpuTime;
    private long totalElapsedTime;
    private final AtomicLong sequence = new AtomicLong(0L);
    final Node node;
    final QueueHandler<NotificationSender> notificationHandler;

    public JPPFNodeTaskMonitor(Node node, String objectName) {
        this.node = node;
        try {
            this.OBJECT_NAME = ObjectNameCache.getObjectName((String)objectName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.notificationHandler = QueueHandler.builder().named("NodeTaskMonitor").handlingElementsAs(sender -> sender.run()).usingSingleDequuerThread().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskExecuted(TaskExecutionEvent event) {
        TaskInformation info = event.getTaskInformation();
        JPPFNodeTaskMonitor jPPFNodeTaskMonitor = this;
        synchronized (jPPFNodeTaskMonitor) {
            ++this.taskCount;
            if (info.hasError()) {
                ++this.taskInErrorCount;
            } else {
                ++this.taskSuccessfulCount;
            }
            this.totalCpuTime += info.getCpuTime();
            this.totalElapsedTime += info.getElapsedTime();
        }
        this.notificationHandler.offer((Object)new NotificationSender(info, null, false));
    }

    public void taskNotification(TaskExecutionEvent event) {
        if (event.isSendViaJmx()) {
            this.notificationHandler.offer((Object)new NotificationSender(event.getTaskInformation(), event.getUserObject(), true));
        }
    }

    public synchronized Integer getTotalTasksExecuted() {
        return this.taskCount;
    }

    public synchronized Long getTotalTaskCpuTime() {
        return this.totalCpuTime;
    }

    public synchronized Long getTotalTaskElapsedTime() {
        return this.totalElapsedTime;
    }

    public synchronized Integer getTotalTasksInError() {
        return this.taskInErrorCount;
    }

    public synchronized Integer getTotalTasksSucessfull() {
        return this.taskSuccessfulCount;
    }

    public synchronized void reset() {
        this.taskCount = 0;
        this.taskInErrorCount = 0;
        this.taskSuccessfulCount = 0;
        this.totalCpuTime = 0L;
        this.totalElapsedTime = 0L;
    }

    private class NotificationSender
    implements Runnable {
        private final TaskInformation info;
        private final Object userObject;
        private final boolean userNotification;

        public NotificationSender(TaskInformation info, Object userObject, boolean userNotification) {
            this.info = info;
            this.userObject = userObject;
            this.userNotification = userNotification;
        }

        @Override
        public void run() {
            if (debugEnabled) {
                log.debug("sending task notification with userObject={}, info={}", this.userObject, (Object)this.info);
            }
            JPPFNodeTaskMonitor.this.sendNotification((Notification)new TaskExecutionNotification(JPPFNodeTaskMonitor.this.OBJECT_NAME, JPPFNodeTaskMonitor.this.sequence.incrementAndGet(), this.info, this.userObject, this.userNotification));
        }
    }
}

