/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jppf.management.AllNodesSelector;
import org.jppf.management.ExecutionPolicySelector;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodeSelector;
import org.jppf.management.forwarding.NodeSelectionProvider;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.server.JPPFDriver;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.nio.nodeserver.async.AsyncJobScheduler;
import org.jppf.server.nio.nodeserver.async.AsyncNodeContext;
import org.jppf.utils.PropertiesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSelectionHelper
implements NodeSelectionProvider {
    private static Logger log = LoggerFactory.getLogger(NodeSelectionHelper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private final JPPFDriver driver;

    public NodeSelectionHelper(JPPFDriver driver) {
        this.driver = driver;
    }

    public boolean isNodeAccepted(BaseNodeContext node, NodeSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector cannot be null");
        }
        if (selector instanceof AllNodesSelector) {
            return true;
        }
        if (node.isPeer()) {
            return false;
        }
        if (selector instanceof ExecutionPolicySelector) {
            ExecutionPolicy policy = ((ExecutionPolicySelector)selector).getPolicy();
            AsyncJobScheduler.preparePolicy(policy, null, this.driver.getStatistics(), 0);
            return policy.evaluate((PropertiesCollection)node.getSystemInformation());
        }
        return selector.accepts(node.getManagementInfo());
    }

    public boolean isNodeAccepted(String nodeUuid, NodeSelector selector) {
        if (nodeUuid == null) {
            throw new IllegalArgumentException("node uuid cannot be null");
        }
        AsyncNodeContext node = this.driver.getAsyncNodeNioServer().getConnection(nodeUuid);
        if (node == null) {
            throw new IllegalArgumentException("unknown selector type: " + selector.getClass().getName());
        }
        return this.isNodeAccepted(node, selector);
    }

    public Set<BaseNodeContext> getChannels(NodeSelector selector) {
        return this.getChannels(selector, false, false);
    }

    public Set<BaseNodeContext> getChannels(NodeSelector selector, boolean includePeers, boolean forForwarding) {
        if (selector == null) {
            throw new IllegalArgumentException("selector cannot be null");
        }
        if (selector instanceof ExecutionPolicySelector) {
            return this.getChannels((ExecutionPolicySelector)selector, includePeers, forForwarding);
        }
        Set<BaseNodeContext> fullSet = this.driver.getAsyncNodeNioServer().getAllChannelsAsSet();
        HashSet<BaseNodeContext> result = new HashSet<BaseNodeContext>();
        for (BaseNodeContext ctx : fullSet) {
            if (!NodeSelectionHelper.nodeAccepted(selector, ctx, includePeers, forForwarding)) continue;
            result.add(ctx);
        }
        return result;
    }

    private Set<BaseNodeContext> getChannels(ExecutionPolicySelector selector, boolean includePeers, boolean forForwarding) {
        ExecutionPolicy policy = selector.getPolicy();
        if (policy.getContext() == null) {
            AsyncJobScheduler.preparePolicy(policy, null, this.driver.getStatistics(), 0);
        }
        HashSet<BaseNodeContext> result = new HashSet<BaseNodeContext>();
        List<BaseNodeContext> allChannels = this.driver.getAsyncNodeNioServer().getAllChannels();
        AsyncJobScheduler.preparePolicy(policy, null, this.driver.getStatistics(), 0);
        for (BaseNodeContext context : allChannels) {
            if (!NodeSelectionHelper.nodeAccepted((NodeSelector)selector, context, includePeers, forForwarding)) continue;
            result.add(context);
        }
        return result;
    }

    private static JPPFManagementInfo getManagementInfo(BaseNodeContext context) {
        JPPFSystemInformation sysInfo;
        JPPFManagementInfo info = context.getManagementInfo();
        if (info == null && (sysInfo = context.getSystemInformation()) != null) {
            info = new JPPFManagementInfo("", "", -1, context.getUuid(), -1, false);
            info.setSystemInfo(sysInfo);
        }
        return info;
    }

    public int getNbChannels(NodeSelector selector, boolean includePeers, boolean forForwarding) {
        if (selector == null) {
            throw new IllegalArgumentException("selector cannot be null");
        }
        if (selector instanceof ExecutionPolicySelector) {
            return this.getNbChannels((ExecutionPolicySelector)selector, includePeers, forForwarding);
        }
        Set<BaseNodeContext> fullSet = this.driver.getAsyncNodeNioServer().getAllChannelsAsSet();
        int result = 0;
        for (BaseNodeContext ctx : fullSet) {
            if (!NodeSelectionHelper.nodeAccepted(selector, ctx, includePeers, forForwarding)) continue;
            ++result;
        }
        return result;
    }

    private int getNbChannels(ExecutionPolicySelector selector, boolean includePeers, boolean forForwarding) {
        ExecutionPolicy policy = selector.getPolicy();
        if (policy.getContext() == null) {
            AsyncJobScheduler.preparePolicy(policy, null, this.driver.getStatistics(), 0);
        }
        int result = 0;
        List<BaseNodeContext> allChannels = this.driver.getAsyncNodeNioServer().getAllChannels();
        AsyncJobScheduler.preparePolicy(policy, null, this.driver.getStatistics(), 0);
        for (BaseNodeContext context : allChannels) {
            if (!NodeSelectionHelper.nodeAccepted((NodeSelector)selector, context, includePeers, forForwarding)) continue;
            ++result;
        }
        return result;
    }

    private static boolean hasWorkingJmxConnection(BaseNodeContext ctx) {
        if (ctx.isPeer()) {
            return true;
        }
        JMXNodeConnectionWrapper jmx = ctx.getJmxConnection();
        return jmx != null && jmx.isConnected();
    }

    private static boolean nodeAccepted(NodeSelector selector, BaseNodeContext context, boolean includePeers, boolean forForwarding) {
        if (!includePeers && context.isPeer()) {
            return false;
        }
        boolean hasJmx = NodeSelectionHelper.hasWorkingJmxConnection(context);
        boolean offline = context.isOffline();
        if (traceEnabled) {
            log.trace("includePeers={}, forForwarding={}, hasJmx={}, offline={} for {}", new Object[]{includePeers, forForwarding, hasJmx, offline, context});
        }
        if (forForwarding && !hasJmx) {
            return false;
        }
        if (!(forForwarding || hasJmx || offline)) {
            return false;
        }
        JPPFManagementInfo info = NodeSelectionHelper.getManagementInfo(context);
        if (info == null) {
            return false;
        }
        return selector.accepts(info);
    }
}

