/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.forwarding;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.jppf.management.NodeSelectionHelper;
import org.jppf.management.NodeSelector;
import org.jppf.management.forwarding.ForwardingNotficationEmitter;
import org.jppf.management.forwarding.ForwardingNotificationManager;
import org.jppf.management.forwarding.NodeForwardingHelper;
import org.jppf.management.forwarding.NodeSelectionProvider;
import org.jppf.server.JPPFDriver;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.concurrent.ConcurrentUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;

public abstract class AbstractNodeForwarding
extends NotificationBroadcasterSupport
implements ForwardingNotficationEmitter {
    private static final Logger log = LoggingUtils.getLogger(AbstractNodeForwarding.class, (boolean)false);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final AtomicLong listenerSequence = new AtomicLong(0L);
    final JPPFDriver driver;
    final ForwardingNotificationManager manager;
    final NodeSelectionHelper selectionHelper;
    final int core;
    final ExecutorService executor;

    public AbstractNodeForwarding(JPPFDriver driver) {
        this.driver = driver;
        this.selectionHelper = new NodeSelectionHelper(driver);
        NodeForwardingHelper.getInstance().setSelectionProvider((NodeSelectionProvider)this.selectionHelper);
        this.manager = new ForwardingNotificationManager(this);
        this.core = (Integer)driver.getConfiguration().get(JPPFProperties.NODE_FORWARDING_POOL_SIZE);
        this.executor = ConcurrentUtils.newFixedExecutor((int)this.core, (String)"NodeForwarding");
        if (debugEnabled) {
            log.debug("initialized JPPFNodeForwarding");
        }
    }

    public String registerForwardingNotificationListener(NodeSelector selector, String mBeanName) throws IllegalArgumentException {
        if (debugEnabled) {
            log.debug("before registering listener with selector={}, mbean={}", (Object)selector, (Object)mBeanName);
        }
        if (selector == null) {
            throw new IllegalArgumentException("selector cannot be null");
        }
        if (mBeanName == null) {
            throw new IllegalArgumentException("mBeanName cannot be null");
        }
        String id = StringUtils.build((Object[])new Object[]{this.driver.getUuid(), Character.valueOf(':'), this.listenerSequence.incrementAndGet()});
        this.manager.addNotificationListener(id, selector, mBeanName);
        if (debugEnabled) {
            log.debug("registered listener id=" + id);
        }
        return id;
    }

    public void unregisterForwardingNotificationListener(String listenerID) throws ListenerNotFoundException {
        if (debugEnabled) {
            log.debug("before unregistering listener id={}", (Object)listenerID);
        }
        this.manager.removeNotificationListener(listenerID);
        if (debugEnabled) {
            log.debug("unregistered listener id={}", (Object)listenerID);
        }
    }

    @Override
    public void sendNotification(Notification notification) {
        if (debugEnabled) {
            log.debug("sending notif: " + notification);
        }
        super.sendNotification(notification);
    }

    NodeSelectionHelper getSelectionHelper() {
        return this.selectionHelper;
    }
}

